/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WalletTransactionStatus;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when the status of a wallet transaction has changed.")
public class WalletTransactionStatusUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_WALLET_ID = "wallet_id";
    @SerializedName(value="wallet_id")
    private String walletId;
    public static final String SERIALIZED_NAME_NEW_STATUS = "new_status";
    @SerializedName(value="new_status")
    private WalletTransactionStatus newStatus;
    public static final String SERIALIZED_NAME_OLD_STATUS = "old_status";
    @SerializedName(value="old_status")
    private WalletTransactionStatus oldStatus;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public WalletTransactionStatusUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`WALLET`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public WalletTransactionStatusUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`WALLET_TRANSACTION_STATUS_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public WalletTransactionStatusUpdateWebhook transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `transaction_id` for the wallet transaction being updated")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public WalletTransactionStatusUpdateWebhook paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `payment_id` associated with the transaction. This will be present in case of `REFUND` and `PIS_PAY_IN`.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public WalletTransactionStatusUpdateWebhook walletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The EMI (E-Money Institution) wallet that this payment is associated with. This wallet is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.")
    public String getWalletId() {
        return this.walletId;
    }

    public void setWalletId(String walletId) {
        this.walletId = walletId;
    }

    public WalletTransactionStatusUpdateWebhook newStatus(WalletTransactionStatus newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletTransactionStatus getNewStatus() {
        return this.newStatus;
    }

    public void setNewStatus(WalletTransactionStatus newStatus) {
        this.newStatus = newStatus;
    }

    public WalletTransactionStatusUpdateWebhook oldStatus(WalletTransactionStatus oldStatus) {
        this.oldStatus = oldStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletTransactionStatus getOldStatus() {
        return this.oldStatus;
    }

    public void setOldStatus(WalletTransactionStatus oldStatus) {
        this.oldStatus = oldStatus;
    }

    public WalletTransactionStatusUpdateWebhook timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp of the update, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2017-09-14T14:42:19.350Z\"`")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public WalletTransactionStatusUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletTransactionStatusUpdateWebhook walletTransactionStatusUpdateWebhook = (WalletTransactionStatusUpdateWebhook)o;
        return Objects.equals(this.webhookType, walletTransactionStatusUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, walletTransactionStatusUpdateWebhook.webhookCode) && Objects.equals(this.transactionId, walletTransactionStatusUpdateWebhook.transactionId) && Objects.equals(this.paymentId, walletTransactionStatusUpdateWebhook.paymentId) && Objects.equals(this.walletId, walletTransactionStatusUpdateWebhook.walletId) && Objects.equals((Object)this.newStatus, (Object)walletTransactionStatusUpdateWebhook.newStatus) && Objects.equals((Object)this.oldStatus, (Object)walletTransactionStatusUpdateWebhook.oldStatus) && Objects.equals(this.timestamp, walletTransactionStatusUpdateWebhook.timestamp) && Objects.equals((Object)this.environment, (Object)walletTransactionStatusUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.transactionId, this.paymentId, this.walletId, this.newStatus, this.oldStatus, this.timestamp, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletTransactionStatusUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    walletId: ").append(this.toIndentedString(this.walletId)).append("\n");
        sb.append("    newStatus: ").append(this.toIndentedString((Object)this.newStatus)).append("\n");
        sb.append("    oldStatus: ").append(this.toIndentedString((Object)this.oldStatus)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

