/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.Cause;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="It is possible for an Asset Report to be returned with missing account owner information. In such cases, the Asset Report will contain warning data in the response, indicating why obtaining the owner information failed.")
public class Warning {
    public static final String SERIALIZED_NAME_WARNING_TYPE = "warning_type";
    @SerializedName(value="warning_type")
    private String warningType;
    public static final String SERIALIZED_NAME_WARNING_CODE = "warning_code";
    @SerializedName(value="warning_code")
    private WarningCodeEnum warningCode;
    public static final String SERIALIZED_NAME_CAUSE = "cause";
    @SerializedName(value="cause")
    private Cause cause;

    public Warning warningType(String warningType) {
        this.warningType = warningType;
        return this;
    }

    @ApiModelProperty(required=true, value="The warning type, which will always be `ASSET_REPORT_WARNING`")
    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String warningType) {
        this.warningType = warningType;
    }

    public Warning warningCode(WarningCodeEnum warningCode) {
        this.warningCode = warningCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The warning code identifies a specific kind of warning. `OWNERS_UNAVAILABLE` indicates that account-owner information is not available.`INVESTMENTS_UNAVAILABLE` indicates that Investments specific information is not available. `TRANSACTIONS_UNAVAILABLE` indicates that transactions information associated with Credit and Depository accounts are unavailable.")
    public WarningCodeEnum getWarningCode() {
        return this.warningCode;
    }

    public void setWarningCode(WarningCodeEnum warningCode) {
        this.warningCode = warningCode;
    }

    public Warning cause(Cause cause) {
        this.cause = cause;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Cause getCause() {
        return this.cause;
    }

    public void setCause(Cause cause) {
        this.cause = cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return Objects.equals(this.warningType, warning.warningType) && Objects.equals((Object)this.warningCode, (Object)warning.warningCode) && Objects.equals(this.cause, warning.cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.warningType, this.warningCode, this.cause});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Warning {\n");
        sb.append("    warningType: ").append(this.toIndentedString(this.warningType)).append("\n");
        sb.append("    warningCode: ").append(this.toIndentedString((Object)this.warningCode)).append("\n");
        sb.append("    cause: ").append(this.toIndentedString(this.cause)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WarningCodeEnum {
        OWNERS_UNAVAILABLE("OWNERS_UNAVAILABLE"),
        INVESTMENTS_UNAVAILABLE("INVESTMENTS_UNAVAILABLE"),
        TRANSACTIONS_UNAVAILABLE("TRANSACTIONS_UNAVAILABLE");

        private String value;

        private WarningCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WarningCodeEnum fromValue(String value) {
            for (WarningCodeEnum b : WarningCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<WarningCodeEnum> {
            public void write(JsonWriter jsonWriter, WarningCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WarningCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WarningCodeEnum.fromValue(value);
            }
        }
    }
}

