/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EntityWatchlistSearchTerms;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for creating an entity screening review")
public class WatchlistScreeningEntityCreateRequest {
    public static final String SERIALIZED_NAME_SEARCH_TERMS = "search_terms";
    @SerializedName(value="search_terms")
    private EntityWatchlistSearchTerms searchTerms;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;

    public WatchlistScreeningEntityCreateRequest searchTerms(EntityWatchlistSearchTerms searchTerms) {
        this.searchTerms = searchTerms;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public EntityWatchlistSearchTerms getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(EntityWatchlistSearchTerms searchTerms) {
        this.searchTerms = searchTerms;
    }

    public WatchlistScreeningEntityCreateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-db-id-3b24110", value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public WatchlistScreeningEntityCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WatchlistScreeningEntityCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningEntityCreateRequest watchlistScreeningEntityCreateRequest = (WatchlistScreeningEntityCreateRequest)o;
        return Objects.equals(this.searchTerms, watchlistScreeningEntityCreateRequest.searchTerms) && Objects.equals(this.clientUserId, watchlistScreeningEntityCreateRequest.clientUserId) && Objects.equals(this.clientId, watchlistScreeningEntityCreateRequest.clientId) && Objects.equals(this.secret, watchlistScreeningEntityCreateRequest.secret);
    }

    public int hashCode() {
        return Objects.hash(this.searchTerms, this.clientUserId, this.clientId, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningEntityCreateRequest {\n");
        sb.append("    searchTerms: ").append(this.toIndentedString(this.searchTerms)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

