/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for listing changes to entity watchlist screenings")
public class WatchlistScreeningEntityHistoryListRequest {
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ENTITY_WATCHLIST_SCREENING_ID = "entity_watchlist_screening_id";
    @SerializedName(value="entity_watchlist_screening_id")
    private String entityWatchlistScreeningId;
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;

    public WatchlistScreeningEntityHistoryListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WatchlistScreeningEntityHistoryListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WatchlistScreeningEntityHistoryListRequest entityWatchlistScreeningId(String entityWatchlistScreeningId) {
        this.entityWatchlistScreeningId = entityWatchlistScreeningId;
        return this;
    }

    @ApiModelProperty(example="entscr_52xR9LKo77r1Np", required=true, value="ID of the associated entity screening.")
    public String getEntityWatchlistScreeningId() {
        return this.entityWatchlistScreeningId;
    }

    public void setEntityWatchlistScreeningId(String entityWatchlistScreeningId) {
        this.entityWatchlistScreeningId = entityWatchlistScreeningId;
    }

    public WatchlistScreeningEntityHistoryListRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", value="An identifier that determines which page of results you receive.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningEntityHistoryListRequest watchlistScreeningEntityHistoryListRequest = (WatchlistScreeningEntityHistoryListRequest)o;
        return Objects.equals(this.secret, watchlistScreeningEntityHistoryListRequest.secret) && Objects.equals(this.clientId, watchlistScreeningEntityHistoryListRequest.clientId) && Objects.equals(this.entityWatchlistScreeningId, watchlistScreeningEntityHistoryListRequest.entityWatchlistScreeningId) && Objects.equals(this.cursor, watchlistScreeningEntityHistoryListRequest.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.secret, this.clientId, this.entityWatchlistScreeningId, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningEntityHistoryListRequest {\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    entityWatchlistScreeningId: ").append(this.toIndentedString(this.entityWatchlistScreeningId)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

