/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EntityWatchlistScreening;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Paginated list of entity watchlist screenings")
public class WatchlistScreeningEntityListResponse {
    public static final String SERIALIZED_NAME_ENTITY_WATCHLIST_SCREENINGS = "entity_watchlist_screenings";
    @SerializedName(value="entity_watchlist_screenings")
    private List<EntityWatchlistScreening> entityWatchlistScreenings = new ArrayList<EntityWatchlistScreening>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WatchlistScreeningEntityListResponse entityWatchlistScreenings(List<EntityWatchlistScreening> entityWatchlistScreenings) {
        this.entityWatchlistScreenings = entityWatchlistScreenings;
        return this;
    }

    public WatchlistScreeningEntityListResponse addEntityWatchlistScreeningsItem(EntityWatchlistScreening entityWatchlistScreeningsItem) {
        this.entityWatchlistScreenings.add(entityWatchlistScreeningsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of entity watchlist screening")
    public List<EntityWatchlistScreening> getEntityWatchlistScreenings() {
        return this.entityWatchlistScreenings;
    }

    public void setEntityWatchlistScreenings(List<EntityWatchlistScreening> entityWatchlistScreenings) {
        this.entityWatchlistScreenings = entityWatchlistScreenings;
    }

    public WatchlistScreeningEntityListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", required=true, value="An identifier that determines which page of results you receive.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public WatchlistScreeningEntityListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningEntityListResponse watchlistScreeningEntityListResponse = (WatchlistScreeningEntityListResponse)o;
        return Objects.equals(this.entityWatchlistScreenings, watchlistScreeningEntityListResponse.entityWatchlistScreenings) && Objects.equals(this.nextCursor, watchlistScreeningEntityListResponse.nextCursor) && Objects.equals(this.requestId, watchlistScreeningEntityListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.entityWatchlistScreenings, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningEntityListResponse {\n");
        sb.append("    entityWatchlistScreenings: ").append(this.toIndentedString(this.entityWatchlistScreenings)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

