/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for creating a review for an entity screening")
public class WatchlistScreeningEntityReviewCreateRequest {
    public static final String SERIALIZED_NAME_CONFIRMED_HITS = "confirmed_hits";
    @SerializedName(value="confirmed_hits")
    private List<String> confirmedHits = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DISMISSED_HITS = "dismissed_hits";
    @SerializedName(value="dismissed_hits")
    private List<String> dismissedHits = new ArrayList<String>();
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ENTITY_WATCHLIST_SCREENING_ID = "entity_watchlist_screening_id";
    @SerializedName(value="entity_watchlist_screening_id")
    private String entityWatchlistScreeningId;

    public WatchlistScreeningEntityReviewCreateRequest confirmedHits(List<String> confirmedHits) {
        this.confirmedHits = confirmedHits;
        return this;
    }

    public WatchlistScreeningEntityReviewCreateRequest addConfirmedHitsItem(String confirmedHitsItem) {
        this.confirmedHits.add(confirmedHitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Hits to mark as a true positive after thorough manual review. These hits will never recur or be updated once dismissed. In most cases, confirmed hits indicate that the customer should be rejected.")
    public List<String> getConfirmedHits() {
        return this.confirmedHits;
    }

    public void setConfirmedHits(List<String> confirmedHits) {
        this.confirmedHits = confirmedHits;
    }

    public WatchlistScreeningEntityReviewCreateRequest dismissedHits(List<String> dismissedHits) {
        this.dismissedHits = dismissedHits;
        return this;
    }

    public WatchlistScreeningEntityReviewCreateRequest addDismissedHitsItem(String dismissedHitsItem) {
        this.dismissedHits.add(dismissedHitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Hits to mark as a false positive after thorough manual review. These hits will never recur or be updated once dismissed.")
    public List<String> getDismissedHits() {
        return this.dismissedHits;
    }

    public void setDismissedHits(List<String> dismissedHits) {
        this.dismissedHits = dismissedHits;
    }

    public WatchlistScreeningEntityReviewCreateRequest comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="These look like legitimate matches, rejecting the customer.", value="A comment submitted by a team member as part of reviewing a watchlist screening.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public WatchlistScreeningEntityReviewCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WatchlistScreeningEntityReviewCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WatchlistScreeningEntityReviewCreateRequest entityWatchlistScreeningId(String entityWatchlistScreeningId) {
        this.entityWatchlistScreeningId = entityWatchlistScreeningId;
        return this;
    }

    @ApiModelProperty(example="entscr_52xR9LKo77r1Np", required=true, value="ID of the associated entity screening.")
    public String getEntityWatchlistScreeningId() {
        return this.entityWatchlistScreeningId;
    }

    public void setEntityWatchlistScreeningId(String entityWatchlistScreeningId) {
        this.entityWatchlistScreeningId = entityWatchlistScreeningId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningEntityReviewCreateRequest watchlistScreeningEntityReviewCreateRequest = (WatchlistScreeningEntityReviewCreateRequest)o;
        return Objects.equals(this.confirmedHits, watchlistScreeningEntityReviewCreateRequest.confirmedHits) && Objects.equals(this.dismissedHits, watchlistScreeningEntityReviewCreateRequest.dismissedHits) && Objects.equals(this.comment, watchlistScreeningEntityReviewCreateRequest.comment) && Objects.equals(this.clientId, watchlistScreeningEntityReviewCreateRequest.clientId) && Objects.equals(this.secret, watchlistScreeningEntityReviewCreateRequest.secret) && Objects.equals(this.entityWatchlistScreeningId, watchlistScreeningEntityReviewCreateRequest.entityWatchlistScreeningId);
    }

    public int hashCode() {
        return Objects.hash(this.confirmedHits, this.dismissedHits, this.comment, this.clientId, this.secret, this.entityWatchlistScreeningId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningEntityReviewCreateRequest {\n");
        sb.append("    confirmedHits: ").append(this.toIndentedString(this.confirmedHits)).append("\n");
        sb.append("    dismissedHits: ").append(this.toIndentedString(this.dismissedHits)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    entityWatchlistScreeningId: ").append(this.toIndentedString(this.entityWatchlistScreeningId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

