/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.UpdateEntityScreeningRequestSearchTerms;
import com.plaid.client.model.WatchlistScreeningEntityUpdateRequestResettableField;
import com.plaid.client.model.WatchlistScreeningStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for editing an entity watchlist screening")
public class WatchlistScreeningEntityUpdateRequest {
    public static final String SERIALIZED_NAME_ENTITY_WATCHLIST_SCREENING_ID = "entity_watchlist_screening_id";
    @SerializedName(value="entity_watchlist_screening_id")
    private String entityWatchlistScreeningId;
    public static final String SERIALIZED_NAME_SEARCH_TERMS = "search_terms";
    @SerializedName(value="search_terms")
    private UpdateEntityScreeningRequestSearchTerms searchTerms;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WatchlistScreeningStatus status;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RESET_FIELDS = "reset_fields";
    @SerializedName(value="reset_fields")
    private List<WatchlistScreeningEntityUpdateRequestResettableField> resetFields = null;

    public WatchlistScreeningEntityUpdateRequest entityWatchlistScreeningId(String entityWatchlistScreeningId) {
        this.entityWatchlistScreeningId = entityWatchlistScreeningId;
        return this;
    }

    @ApiModelProperty(example="entscr_52xR9LKo77r1Np", required=true, value="ID of the associated entity screening.")
    public String getEntityWatchlistScreeningId() {
        return this.entityWatchlistScreeningId;
    }

    public void setEntityWatchlistScreeningId(String entityWatchlistScreeningId) {
        this.entityWatchlistScreeningId = entityWatchlistScreeningId;
    }

    public WatchlistScreeningEntityUpdateRequest searchTerms(UpdateEntityScreeningRequestSearchTerms searchTerms) {
        this.searchTerms = searchTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UpdateEntityScreeningRequestSearchTerms getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(UpdateEntityScreeningRequestSearchTerms searchTerms) {
        this.searchTerms = searchTerms;
    }

    public WatchlistScreeningEntityUpdateRequest assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="54350110fedcbaf01234ffee", value="ID of the associated user.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public WatchlistScreeningEntityUpdateRequest status(WatchlistScreeningStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WatchlistScreeningStatus getStatus() {
        return this.status;
    }

    public void setStatus(WatchlistScreeningStatus status) {
        this.status = status;
    }

    public WatchlistScreeningEntityUpdateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-db-id-3b24110", value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public WatchlistScreeningEntityUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WatchlistScreeningEntityUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WatchlistScreeningEntityUpdateRequest resetFields(List<WatchlistScreeningEntityUpdateRequestResettableField> resetFields) {
        this.resetFields = resetFields;
        return this;
    }

    public WatchlistScreeningEntityUpdateRequest addResetFieldsItem(WatchlistScreeningEntityUpdateRequestResettableField resetFieldsItem) {
        if (this.resetFields == null) {
            this.resetFields = new ArrayList<WatchlistScreeningEntityUpdateRequestResettableField>();
        }
        this.resetFields.add(resetFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of fields to reset back to null")
    public List<WatchlistScreeningEntityUpdateRequestResettableField> getResetFields() {
        return this.resetFields;
    }

    public void setResetFields(List<WatchlistScreeningEntityUpdateRequestResettableField> resetFields) {
        this.resetFields = resetFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningEntityUpdateRequest watchlistScreeningEntityUpdateRequest = (WatchlistScreeningEntityUpdateRequest)o;
        return Objects.equals(this.entityWatchlistScreeningId, watchlistScreeningEntityUpdateRequest.entityWatchlistScreeningId) && Objects.equals(this.searchTerms, watchlistScreeningEntityUpdateRequest.searchTerms) && Objects.equals(this.assignee, watchlistScreeningEntityUpdateRequest.assignee) && Objects.equals((Object)this.status, (Object)watchlistScreeningEntityUpdateRequest.status) && Objects.equals(this.clientUserId, watchlistScreeningEntityUpdateRequest.clientUserId) && Objects.equals(this.clientId, watchlistScreeningEntityUpdateRequest.clientId) && Objects.equals(this.secret, watchlistScreeningEntityUpdateRequest.secret) && Objects.equals(this.resetFields, watchlistScreeningEntityUpdateRequest.resetFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityWatchlistScreeningId, this.searchTerms, this.assignee, this.status, this.clientUserId, this.clientId, this.secret, this.resetFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningEntityUpdateRequest {\n");
        sb.append("    entityWatchlistScreeningId: ").append(this.toIndentedString(this.entityWatchlistScreeningId)).append("\n");
        sb.append("    searchTerms: ").append(this.toIndentedString(this.searchTerms)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    resetFields: ").append(this.toIndentedString(this.resetFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

