/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IndividualWatchlistCode;
import com.plaid.client.model.ScreeningHitAnalysis;
import com.plaid.client.model.ScreeningHitData;
import com.plaid.client.model.WatchlistScreeningHitStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data from a government watchlist or PEP list that has been attached to the screening.")
public class WatchlistScreeningHit {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REVIEW_STATUS = "review_status";
    @SerializedName(value="review_status")
    private WatchlistScreeningHitStatus reviewStatus;
    public static final String SERIALIZED_NAME_FIRST_ACTIVE = "first_active";
    @SerializedName(value="first_active")
    private Timestamp firstActive;
    public static final String SERIALIZED_NAME_INACTIVE_SINCE = "inactive_since";
    @SerializedName(value="inactive_since")
    private OffsetDateTime inactiveSince;
    public static final String SERIALIZED_NAME_HISTORICAL_SINCE = "historical_since";
    @SerializedName(value="historical_since")
    private OffsetDateTime historicalSince;
    public static final String SERIALIZED_NAME_LIST_CODE = "list_code";
    @SerializedName(value="list_code")
    private IndividualWatchlistCode listCode;
    public static final String SERIALIZED_NAME_PLAID_UID = "plaid_uid";
    @SerializedName(value="plaid_uid")
    private String plaidUid;
    public static final String SERIALIZED_NAME_SOURCE_UID = "source_uid";
    @SerializedName(value="source_uid")
    private String sourceUid;
    public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
    @SerializedName(value="analysis")
    private ScreeningHitAnalysis analysis;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private ScreeningHitData data;

    public WatchlistScreeningHit id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="scrhit_52xR9LKo77r1Np", required=true, value="ID of the associated screening hit.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WatchlistScreeningHit reviewStatus(WatchlistScreeningHitStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WatchlistScreeningHitStatus getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(WatchlistScreeningHitStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public WatchlistScreeningHit firstActive(Timestamp firstActive) {
        this.firstActive = firstActive;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getFirstActive() {
        return this.firstActive;
    }

    public void setFirstActive(Timestamp firstActive) {
        this.firstActive = firstActive;
    }

    public WatchlistScreeningHit inactiveSince(OffsetDateTime inactiveSince) {
        this.inactiveSince = inactiveSince;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getInactiveSince() {
        return this.inactiveSince;
    }

    public void setInactiveSince(OffsetDateTime inactiveSince) {
        this.inactiveSince = inactiveSince;
    }

    public WatchlistScreeningHit historicalSince(OffsetDateTime historicalSince) {
        this.historicalSince = historicalSince;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getHistoricalSince() {
        return this.historicalSince;
    }

    public void setHistoricalSince(OffsetDateTime historicalSince) {
        this.historicalSince = historicalSince;
    }

    public WatchlistScreeningHit listCode(IndividualWatchlistCode listCode) {
        this.listCode = listCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IndividualWatchlistCode getListCode() {
        return this.listCode;
    }

    public void setListCode(IndividualWatchlistCode listCode) {
        this.listCode = listCode;
    }

    public WatchlistScreeningHit plaidUid(String plaidUid) {
        this.plaidUid = plaidUid;
        return this;
    }

    @ApiModelProperty(example="uid_3NggckTimGSJHS", required=true, value="A universal identifier for a watchlist individual that is stable across searches and updates.")
    public String getPlaidUid() {
        return this.plaidUid;
    }

    public void setPlaidUid(String plaidUid) {
        this.plaidUid = plaidUid;
    }

    public WatchlistScreeningHit sourceUid(String sourceUid) {
        this.sourceUid = sourceUid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="26192ABC", required=true, value="The identifier provided by the source sanction or watchlist. When one is not provided by the source, this is `null`.")
    public String getSourceUid() {
        return this.sourceUid;
    }

    public void setSourceUid(String sourceUid) {
        this.sourceUid = sourceUid;
    }

    public WatchlistScreeningHit analysis(ScreeningHitAnalysis analysis) {
        this.analysis = analysis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ScreeningHitAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(ScreeningHitAnalysis analysis) {
        this.analysis = analysis;
    }

    public WatchlistScreeningHit data(ScreeningHitData data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ScreeningHitData getData() {
        return this.data;
    }

    public void setData(ScreeningHitData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningHit watchlistScreeningHit = (WatchlistScreeningHit)o;
        return Objects.equals(this.id, watchlistScreeningHit.id) && Objects.equals((Object)this.reviewStatus, (Object)watchlistScreeningHit.reviewStatus) && Objects.equals(this.firstActive, watchlistScreeningHit.firstActive) && Objects.equals(this.inactiveSince, watchlistScreeningHit.inactiveSince) && Objects.equals(this.historicalSince, watchlistScreeningHit.historicalSince) && Objects.equals((Object)this.listCode, (Object)watchlistScreeningHit.listCode) && Objects.equals(this.plaidUid, watchlistScreeningHit.plaidUid) && Objects.equals(this.sourceUid, watchlistScreeningHit.sourceUid) && Objects.equals(this.analysis, watchlistScreeningHit.analysis) && Objects.equals(this.data, watchlistScreeningHit.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.reviewStatus, this.firstActive, this.inactiveSince, this.historicalSince, this.listCode, this.plaidUid, this.sourceUid, this.analysis, this.data});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningHit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    reviewStatus: ").append(this.toIndentedString((Object)this.reviewStatus)).append("\n");
        sb.append("    firstActive: ").append(this.toIndentedString(this.firstActive)).append("\n");
        sb.append("    inactiveSince: ").append(this.toIndentedString(this.inactiveSince)).append("\n");
        sb.append("    historicalSince: ").append(this.toIndentedString(this.historicalSince)).append("\n");
        sb.append("    listCode: ").append(this.toIndentedString((Object)this.listCode)).append("\n");
        sb.append("    plaidUid: ").append(this.toIndentedString(this.plaidUid)).append("\n");
        sb.append("    sourceUid: ").append(this.toIndentedString(this.sourceUid)).append("\n");
        sb.append("    analysis: ").append(this.toIndentedString(this.analysis)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

