/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WatchlistScreeningIndividual;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Paginated list of individual watchlist screenings.")
public class WatchlistScreeningIndividualHistoryListResponse {
    public static final String SERIALIZED_NAME_WATCHLIST_SCREENINGS = "watchlist_screenings";
    @SerializedName(value="watchlist_screenings")
    private List<WatchlistScreeningIndividual> watchlistScreenings = new ArrayList<WatchlistScreeningIndividual>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WatchlistScreeningIndividualHistoryListResponse watchlistScreenings(List<WatchlistScreeningIndividual> watchlistScreenings) {
        this.watchlistScreenings = watchlistScreenings;
        return this;
    }

    public WatchlistScreeningIndividualHistoryListResponse addWatchlistScreeningsItem(WatchlistScreeningIndividual watchlistScreeningsItem) {
        this.watchlistScreenings.add(watchlistScreeningsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of individual watchlist screenings")
    public List<WatchlistScreeningIndividual> getWatchlistScreenings() {
        return this.watchlistScreenings;
    }

    public void setWatchlistScreenings(List<WatchlistScreeningIndividual> watchlistScreenings) {
        this.watchlistScreenings = watchlistScreenings;
    }

    public WatchlistScreeningIndividualHistoryListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", required=true, value="An identifier that determines which page of results you receive.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public WatchlistScreeningIndividualHistoryListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningIndividualHistoryListResponse watchlistScreeningIndividualHistoryListResponse = (WatchlistScreeningIndividualHistoryListResponse)o;
        return Objects.equals(this.watchlistScreenings, watchlistScreeningIndividualHistoryListResponse.watchlistScreenings) && Objects.equals(this.nextCursor, watchlistScreeningIndividualHistoryListResponse.nextCursor) && Objects.equals(this.requestId, watchlistScreeningIndividualHistoryListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.watchlistScreenings, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningIndividualHistoryListResponse {\n");
        sb.append("    watchlistScreenings: ").append(this.toIndentedString(this.watchlistScreenings)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

