/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WatchlistScreeningHit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Paginated list of individual watchlist screening hits")
public class WatchlistScreeningIndividualHitListResponse {
    public static final String SERIALIZED_NAME_WATCHLIST_SCREENING_HITS = "watchlist_screening_hits";
    @SerializedName(value="watchlist_screening_hits")
    private List<WatchlistScreeningHit> watchlistScreeningHits = new ArrayList<WatchlistScreeningHit>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WatchlistScreeningIndividualHitListResponse watchlistScreeningHits(List<WatchlistScreeningHit> watchlistScreeningHits) {
        this.watchlistScreeningHits = watchlistScreeningHits;
        return this;
    }

    public WatchlistScreeningIndividualHitListResponse addWatchlistScreeningHitsItem(WatchlistScreeningHit watchlistScreeningHitsItem) {
        this.watchlistScreeningHits.add(watchlistScreeningHitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of individual watchlist screening hits")
    public List<WatchlistScreeningHit> getWatchlistScreeningHits() {
        return this.watchlistScreeningHits;
    }

    public void setWatchlistScreeningHits(List<WatchlistScreeningHit> watchlistScreeningHits) {
        this.watchlistScreeningHits = watchlistScreeningHits;
    }

    public WatchlistScreeningIndividualHitListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", required=true, value="An identifier that determines which page of results you receive.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public WatchlistScreeningIndividualHitListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningIndividualHitListResponse watchlistScreeningIndividualHitListResponse = (WatchlistScreeningIndividualHitListResponse)o;
        return Objects.equals(this.watchlistScreeningHits, watchlistScreeningIndividualHitListResponse.watchlistScreeningHits) && Objects.equals(this.nextCursor, watchlistScreeningIndividualHitListResponse.nextCursor) && Objects.equals(this.requestId, watchlistScreeningIndividualHitListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.watchlistScreeningHits, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningIndividualHitListResponse {\n");
        sb.append("    watchlistScreeningHits: ").append(this.toIndentedString(this.watchlistScreeningHits)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

