/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WatchlistScreeningStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for listinging watchlist screenings for individuals")
public class WatchlistScreeningIndividualListRequest {
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_WATCHLIST_PROGRAM_ID = "watchlist_program_id";
    @SerializedName(value="watchlist_program_id")
    private String watchlistProgramId;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WatchlistScreeningStatus status;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;

    public WatchlistScreeningIndividualListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WatchlistScreeningIndividualListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WatchlistScreeningIndividualListRequest watchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
        return this;
    }

    @ApiModelProperty(example="prg_2eRPsDnL66rZ7H", required=true, value="ID of the associated program.")
    public String getWatchlistProgramId() {
        return this.watchlistProgramId;
    }

    public void setWatchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
    }

    public WatchlistScreeningIndividualListRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-db-id-3b24110", value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public WatchlistScreeningIndividualListRequest status(WatchlistScreeningStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WatchlistScreeningStatus getStatus() {
        return this.status;
    }

    public void setStatus(WatchlistScreeningStatus status) {
        this.status = status;
    }

    public WatchlistScreeningIndividualListRequest assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="54350110fedcbaf01234ffee", value="ID of the associated user.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public WatchlistScreeningIndividualListRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", value="An identifier that determines which page of results you receive.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningIndividualListRequest watchlistScreeningIndividualListRequest = (WatchlistScreeningIndividualListRequest)o;
        return Objects.equals(this.secret, watchlistScreeningIndividualListRequest.secret) && Objects.equals(this.clientId, watchlistScreeningIndividualListRequest.clientId) && Objects.equals(this.watchlistProgramId, watchlistScreeningIndividualListRequest.watchlistProgramId) && Objects.equals(this.clientUserId, watchlistScreeningIndividualListRequest.clientUserId) && Objects.equals((Object)this.status, (Object)watchlistScreeningIndividualListRequest.status) && Objects.equals(this.assignee, watchlistScreeningIndividualListRequest.assignee) && Objects.equals(this.cursor, watchlistScreeningIndividualListRequest.cursor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.secret, this.clientId, this.watchlistProgramId, this.clientUserId, this.status, this.assignee, this.cursor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningIndividualListRequest {\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    watchlistProgramId: ").append(this.toIndentedString(this.watchlistProgramId)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

