/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for fetching an individual watchlist program")
public class WatchlistScreeningIndividualProgramGetRequest {
    public static final String SERIALIZED_NAME_WATCHLIST_PROGRAM_ID = "watchlist_program_id";
    @SerializedName(value="watchlist_program_id")
    private String watchlistProgramId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;

    public WatchlistScreeningIndividualProgramGetRequest watchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
        return this;
    }

    @ApiModelProperty(example="prg_2eRPsDnL66rZ7H", required=true, value="ID of the associated program.")
    public String getWatchlistProgramId() {
        return this.watchlistProgramId;
    }

    public void setWatchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
    }

    public WatchlistScreeningIndividualProgramGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WatchlistScreeningIndividualProgramGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningIndividualProgramGetRequest watchlistScreeningIndividualProgramGetRequest = (WatchlistScreeningIndividualProgramGetRequest)o;
        return Objects.equals(this.watchlistProgramId, watchlistScreeningIndividualProgramGetRequest.watchlistProgramId) && Objects.equals(this.secret, watchlistScreeningIndividualProgramGetRequest.secret) && Objects.equals(this.clientId, watchlistScreeningIndividualProgramGetRequest.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.watchlistProgramId, this.secret, this.clientId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningIndividualProgramGetRequest {\n");
        sb.append("    watchlistProgramId: ").append(this.toIndentedString(this.watchlistProgramId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

