/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IndividualWatchlistProgram;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Paginated list of individual watchlist screening programs")
public class WatchlistScreeningIndividualProgramListResponse {
    public static final String SERIALIZED_NAME_WATCHLIST_PROGRAMS = "watchlist_programs";
    @SerializedName(value="watchlist_programs")
    private List<IndividualWatchlistProgram> watchlistPrograms = new ArrayList<IndividualWatchlistProgram>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WatchlistScreeningIndividualProgramListResponse watchlistPrograms(List<IndividualWatchlistProgram> watchlistPrograms) {
        this.watchlistPrograms = watchlistPrograms;
        return this;
    }

    public WatchlistScreeningIndividualProgramListResponse addWatchlistProgramsItem(IndividualWatchlistProgram watchlistProgramsItem) {
        this.watchlistPrograms.add(watchlistProgramsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of individual watchlist screening programs")
    public List<IndividualWatchlistProgram> getWatchlistPrograms() {
        return this.watchlistPrograms;
    }

    public void setWatchlistPrograms(List<IndividualWatchlistProgram> watchlistPrograms) {
        this.watchlistPrograms = watchlistPrograms;
    }

    public WatchlistScreeningIndividualProgramListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", required=true, value="An identifier that determines which page of results you receive.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public WatchlistScreeningIndividualProgramListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningIndividualProgramListResponse watchlistScreeningIndividualProgramListResponse = (WatchlistScreeningIndividualProgramListResponse)o;
        return Objects.equals(this.watchlistPrograms, watchlistScreeningIndividualProgramListResponse.watchlistPrograms) && Objects.equals(this.nextCursor, watchlistScreeningIndividualProgramListResponse.nextCursor) && Objects.equals(this.requestId, watchlistScreeningIndividualProgramListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.watchlistPrograms, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningIndividualProgramListResponse {\n");
        sb.append("    watchlistPrograms: ").append(this.toIndentedString(this.watchlistPrograms)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

