/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WatchlistScreeningAuditTrail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A review submitted by a team member for an individual watchlist screening. A review can be either a comment on the current screening state, actions taken against hits attached to the watchlist screening, or both.")
public class WatchlistScreeningIndividualReviewCreateResponse {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CONFIRMED_HITS = "confirmed_hits";
    @SerializedName(value="confirmed_hits")
    private List<String> confirmedHits = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DISMISSED_HITS = "dismissed_hits";
    @SerializedName(value="dismissed_hits")
    private List<String> dismissedHits = new ArrayList<String>();
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_AUDIT_TRAIL = "audit_trail";
    @SerializedName(value="audit_trail")
    private WatchlistScreeningAuditTrail auditTrail;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WatchlistScreeningIndividualReviewCreateResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="rev_aCLNRxK3UVzn2r", required=true, value="ID of the associated review.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WatchlistScreeningIndividualReviewCreateResponse confirmedHits(List<String> confirmedHits) {
        this.confirmedHits = confirmedHits;
        return this;
    }

    public WatchlistScreeningIndividualReviewCreateResponse addConfirmedHitsItem(String confirmedHitsItem) {
        this.confirmedHits.add(confirmedHitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Hits marked as a true positive after thorough manual review. These hits will never recur or be updated once dismissed. In most cases, confirmed hits indicate that the customer should be rejected.")
    public List<String> getConfirmedHits() {
        return this.confirmedHits;
    }

    public void setConfirmedHits(List<String> confirmedHits) {
        this.confirmedHits = confirmedHits;
    }

    public WatchlistScreeningIndividualReviewCreateResponse dismissedHits(List<String> dismissedHits) {
        this.dismissedHits = dismissedHits;
        return this;
    }

    public WatchlistScreeningIndividualReviewCreateResponse addDismissedHitsItem(String dismissedHitsItem) {
        this.dismissedHits.add(dismissedHitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Hits marked as a false positive after thorough manual review. These hits will never recur or be updated once dismissed.")
    public List<String> getDismissedHits() {
        return this.dismissedHits;
    }

    public void setDismissedHits(List<String> dismissedHits) {
        this.dismissedHits = dismissedHits;
    }

    public WatchlistScreeningIndividualReviewCreateResponse comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="These look like legitimate matches, rejecting the customer.", required=true, value="A comment submitted by a team member as part of reviewing a watchlist screening.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public WatchlistScreeningIndividualReviewCreateResponse auditTrail(WatchlistScreeningAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WatchlistScreeningAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(WatchlistScreeningAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
    }

    public WatchlistScreeningIndividualReviewCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningIndividualReviewCreateResponse watchlistScreeningIndividualReviewCreateResponse = (WatchlistScreeningIndividualReviewCreateResponse)o;
        return Objects.equals(this.id, watchlistScreeningIndividualReviewCreateResponse.id) && Objects.equals(this.confirmedHits, watchlistScreeningIndividualReviewCreateResponse.confirmedHits) && Objects.equals(this.dismissedHits, watchlistScreeningIndividualReviewCreateResponse.dismissedHits) && Objects.equals(this.comment, watchlistScreeningIndividualReviewCreateResponse.comment) && Objects.equals(this.auditTrail, watchlistScreeningIndividualReviewCreateResponse.auditTrail) && Objects.equals(this.requestId, watchlistScreeningIndividualReviewCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.confirmedHits, this.dismissedHits, this.comment, this.auditTrail, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningIndividualReviewCreateResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    confirmedHits: ").append(this.toIndentedString(this.confirmedHits)).append("\n");
        sb.append("    dismissedHits: ").append(this.toIndentedString(this.dismissedHits)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    auditTrail: ").append(this.toIndentedString(this.auditTrail)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

