/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Search inputs for creating a watchlist screening")
public class WatchlistScreeningRequestSearchTerms {
    public static final String SERIALIZED_NAME_WATCHLIST_PROGRAM_ID = "watchlist_program_id";
    @SerializedName(value="watchlist_program_id")
    private String watchlistProgramId;
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_DOCUMENT_NUMBER = "document_number";
    @SerializedName(value="document_number")
    private String documentNumber;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;

    public WatchlistScreeningRequestSearchTerms watchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
        return this;
    }

    @ApiModelProperty(example="prg_2eRPsDnL66rZ7H", required=true, value="ID of the associated program.")
    public String getWatchlistProgramId() {
        return this.watchlistProgramId;
    }

    public void setWatchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
    }

    public WatchlistScreeningRequestSearchTerms legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(example="Aleksey Potemkin", required=true, value="The legal name of the individual being screened.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public WatchlistScreeningRequestSearchTerms dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public WatchlistScreeningRequestSearchTerms documentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="C31195855", value="The numeric or alphanumeric identifier associated with this document.")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public WatchlistScreeningRequestSearchTerms country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="Valid, capitalized, two-letter ISO code representing the country of this object. Must be in ISO 3166-1 alpha-2 form.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningRequestSearchTerms watchlistScreeningRequestSearchTerms = (WatchlistScreeningRequestSearchTerms)o;
        return Objects.equals(this.watchlistProgramId, watchlistScreeningRequestSearchTerms.watchlistProgramId) && Objects.equals(this.legalName, watchlistScreeningRequestSearchTerms.legalName) && Objects.equals(this.dateOfBirth, watchlistScreeningRequestSearchTerms.dateOfBirth) && Objects.equals(this.documentNumber, watchlistScreeningRequestSearchTerms.documentNumber) && Objects.equals(this.country, watchlistScreeningRequestSearchTerms.country);
    }

    public int hashCode() {
        return Objects.hash(this.watchlistProgramId, this.legalName, this.dateOfBirth, this.documentNumber, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningRequestSearchTerms {\n");
        sb.append("    watchlistProgramId: ").append(this.toIndentedString(this.watchlistProgramId)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    documentNumber: ").append(this.toIndentedString(this.documentNumber)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

