/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Search terms for creating an individual watchlist screening")
public class WatchlistScreeningSearchTerms {
    public static final String SERIALIZED_NAME_WATCHLIST_PROGRAM_ID = "watchlist_program_id";
    @SerializedName(value="watchlist_program_id")
    private String watchlistProgramId;
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_DOCUMENT_NUMBER = "document_number";
    @SerializedName(value="document_number")
    private String documentNumber;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;

    public WatchlistScreeningSearchTerms watchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
        return this;
    }

    @ApiModelProperty(example="prg_2eRPsDnL66rZ7H", required=true, value="ID of the associated program.")
    public String getWatchlistProgramId() {
        return this.watchlistProgramId;
    }

    public void setWatchlistProgramId(String watchlistProgramId) {
        this.watchlistProgramId = watchlistProgramId;
    }

    public WatchlistScreeningSearchTerms legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(example="Aleksey Potemkin", required=true, value="The legal name of the individual being screened.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public WatchlistScreeningSearchTerms dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public WatchlistScreeningSearchTerms documentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="C31195855", required=true, value="The numeric or alphanumeric identifier associated with this document.")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public WatchlistScreeningSearchTerms country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", required=true, value="Valid, capitalized, two-letter ISO code representing the country of this object. Must be in ISO 3166-1 alpha-2 form.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public WatchlistScreeningSearchTerms version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The current version of the search terms. Starts at `1` and increments with each edit to `search_terms`.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchlistScreeningSearchTerms watchlistScreeningSearchTerms = (WatchlistScreeningSearchTerms)o;
        return Objects.equals(this.watchlistProgramId, watchlistScreeningSearchTerms.watchlistProgramId) && Objects.equals(this.legalName, watchlistScreeningSearchTerms.legalName) && Objects.equals(this.dateOfBirth, watchlistScreeningSearchTerms.dateOfBirth) && Objects.equals(this.documentNumber, watchlistScreeningSearchTerms.documentNumber) && Objects.equals(this.country, watchlistScreeningSearchTerms.country) && Objects.equals(this.version, watchlistScreeningSearchTerms.version);
    }

    public int hashCode() {
        return Objects.hash(this.watchlistProgramId, this.legalName, this.dateOfBirth, this.documentNumber, this.country, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatchlistScreeningSearchTerms {\n");
        sb.append("    watchlistProgramId: ").append(this.toIndentedString(this.watchlistProgramId)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    documentNumber: ").append(this.toIndentedString(this.documentNumber)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

