/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when an Item's webhook is updated. This will be sent to the newly specified webhook.")
public class WebhookUpdateAcknowledgedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_NEW_WEBHOOK_URL = "new_webhook_url";
    @SerializedName(value="new_webhook_url")
    private String newWebhookUrl;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public WebhookUpdateAcknowledgedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`ITEM`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public WebhookUpdateAcknowledgedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`WEBHOOK_UPDATE_ACKNOWLEDGED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public WebhookUpdateAcknowledgedWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public WebhookUpdateAcknowledgedWebhook newWebhookUrl(String newWebhookUrl) {
        this.newWebhookUrl = newWebhookUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The new webhook URL")
    public String getNewWebhookUrl() {
        return this.newWebhookUrl;
    }

    public void setNewWebhookUrl(String newWebhookUrl) {
        this.newWebhookUrl = newWebhookUrl;
    }

    public WebhookUpdateAcknowledgedWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public WebhookUpdateAcknowledgedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookUpdateAcknowledgedWebhook webhookUpdateAcknowledgedWebhook = (WebhookUpdateAcknowledgedWebhook)o;
        return Objects.equals(this.webhookType, webhookUpdateAcknowledgedWebhook.webhookType) && Objects.equals(this.webhookCode, webhookUpdateAcknowledgedWebhook.webhookCode) && Objects.equals(this.itemId, webhookUpdateAcknowledgedWebhook.itemId) && Objects.equals(this.newWebhookUrl, webhookUpdateAcknowledgedWebhook.newWebhookUrl) && Objects.equals(this.error, webhookUpdateAcknowledgedWebhook.error) && Objects.equals((Object)this.environment, (Object)webhookUpdateAcknowledgedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.newWebhookUrl, this.error, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookUpdateAcknowledgedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    newWebhookUrl: ").append(this.toIndentedString(this.newWebhookUrl)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

