/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.Optional;
import com.plaid.client.request.common.BaseClientRequest;
import java.util.List;

public final class AssetReportCreateRequest
extends BaseClientRequest {
    private List<String> accessTokens;
    private Integer daysRequested;
    private Optional<Options> options = Optional.empty();

    public AssetReportCreateRequest(List<String> accessTokens, int daysRequested) {
        this.accessTokens = accessTokens;
        this.daysRequested = daysRequested;
    }

    public AssetReportCreateRequest withWebhook(String webhook) {
        Util.notNull(webhook, "webhook");
        this.options = this.options.orElse(new Options());
        this.options.get().webhook = webhook;
        return this;
    }

    public AssetReportCreateRequest withClientReportId(String clientReportId) {
        Util.notNull(clientReportId, "clientReportId");
        this.options = this.options.orElse(new Options());
        this.options.get().clientReportId = clientReportId;
        return this;
    }

    public AssetReportCreateRequest withClientUserId(String clientUserId) {
        Util.notNull(clientUserId, "clientUserId");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).clientUserId = clientUserId;
        return this;
    }

    public AssetReportCreateRequest withFirstName(String firstName) {
        Util.notNull(firstName, "firstName");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).firstName = firstName;
        return this;
    }

    public AssetReportCreateRequest withMiddleName(String middleName) {
        Util.notNull(middleName, "middleName");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).middleName = middleName;
        return this;
    }

    public AssetReportCreateRequest withLastName(String lastName) {
        Util.notNull(lastName, "lastName");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).lastName = lastName;
        return this;
    }

    public AssetReportCreateRequest withSsn(String ssn) {
        Util.notNull(ssn, "ssn");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).ssn = ssn;
        return this;
    }

    public AssetReportCreateRequest withPhoneNumber(String phoneNumber) {
        Util.notNull(phoneNumber, "phoneNumber");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).phoneNumber = phoneNumber;
        return this;
    }

    public AssetReportCreateRequest withEmail(String email) {
        Util.notNull(email, "email");
        this.options = this.options.orElse(new Options());
        this.options.get().user = this.options.get().user.orElse(new Options.UserOptions());
        ((Options.UserOptions)this.options.get().user.get()).email = email;
        return this;
    }

    public static class Options {
        private String webhook;
        private Optional<UserOptions> user = Optional.empty();
        private String clientReportId;

        public String getClientReportId() {
            return this.clientReportId;
        }

        public void setClientReportId(String clientReportId) {
            this.clientReportId = clientReportId;
        }

        public Optional<UserOptions> getUser() {
            return this.user;
        }

        public void setUser(Optional<UserOptions> user) {
            this.user = user;
        }

        public String getWebhook() {
            return this.webhook;
        }

        public void setWebhook(String webhook) {
            this.webhook = webhook;
        }

        public static class UserOptions {
            private String clientUserId;
            private String firstName;
            private String middleName;
            private String lastName;
            private String ssn;
            private String phoneNumber;
            private String email;

            public String getClientUserId() {
                return this.clientUserId;
            }

            public void setClientUserId(String clientUserId) {
                this.clientUserId = clientUserId;
            }

            public String getFirstName() {
                return this.firstName;
            }

            public void setFirstName(String firstName) {
                this.firstName = firstName;
            }

            public String getMiddleName() {
                return this.middleName;
            }

            public void setMiddleName(String middleName) {
                this.middleName = middleName;
            }

            public String getLastName() {
                return this.lastName;
            }

            public void setLastName(String lastName) {
                this.lastName = lastName;
            }

            public String getSsn() {
                return this.ssn;
            }

            public void setSsn(String ssn) {
                this.ssn = ssn;
            }

            public String getPhoneNumber() {
                return this.phoneNumber;
            }

            public void setPhoneNumber(String phoneNumber) {
                this.phoneNumber = phoneNumber;
            }

            public String getEmail() {
                return this.email;
            }

            public void setEmail(String email) {
                this.email = email;
            }
        }
    }
}

