/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.plaid.client.PlaidApiService;
import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.CredentialInjectingTypeAdapterFactory;
import com.plaid.client.internal.gson.ImmutableListStripUnknownEnumsTypeAdapterFactory;
import com.plaid.client.internal.gson.InvestmentsTransactionsBaseOptionsSerializer;
import com.plaid.client.internal.gson.OptionalTypeAdapterFactory;
import com.plaid.client.internal.gson.RequiredFieldTypeAdapterFactory;
import com.plaid.client.internal.gson.TransactionsBaseOptionsSerializer;
import com.plaid.client.request.InvestmentsTransactionsGetRequest;
import com.plaid.client.request.TransactionsGetRequest;
import com.plaid.client.response.ErrorResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public final class PlaidClient {
    private static final ConnectionSpec CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
    private static String headerVersion;
    private final PlaidApiService plaidApiService;
    private final Retrofit retrofit;

    private PlaidClient(PlaidApiService plaidApiService, Retrofit retrofit) {
        this.plaidApiService = plaidApiService;
        this.retrofit = retrofit;
    }

    public PlaidApiService service() {
        return this.plaidApiService;
    }

    public ErrorResponse parseError(retrofit2.Response response) {
        if (response.isSuccessful()) {
            throw new IllegalArgumentException("Response must be unsuccessful.");
        }
        Converter responseBodyObjectConverter = this.retrofit.responseBodyConverter(ErrorResponse.class, new Annotation[0]);
        try {
            return (ErrorResponse)responseBodyObjectConverter.convert((Object)response.errorBody());
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not parse error response", ex);
        }
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static String getUserAgentHeader() {
        return String.format("Plaid Java v%s", "5.3.0");
    }

    public static class Builder {
        public static String DEFAULT_PRODUCTION_BASE_URL = "https://production.plaid.com";
        public static String DEFAULT_DEVELOPMENT_BASE_URL = "https://development.plaid.com";
        public static String DEFAULT_SANDBOX_BASE_URL = "https://sandbox.plaid.com";
        public static long DEFAULT_READ_TIMEOUT_SECONDS = 300L;
        public static long DEFAULT_CONNECT_TIMEOUT_SECONDS = 5L;
        private final OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().readTimeout(DEFAULT_READ_TIMEOUT_SECONDS, TimeUnit.SECONDS).connectTimeout(DEFAULT_CONNECT_TIMEOUT_SECONDS, TimeUnit.SECONDS).followSslRedirects(false).addInterceptor((Interceptor)new PlaidApiHeadersInterceptor()).connectionSpecs(Collections.singletonList(PlaidClient.access$200()));
        private String baseUrl;
        private HttpLoggingInterceptor.Level httpLogLevel;
        private String publicKey;
        private String clientId;
        private String secret;

        private Builder() {
        }

        public PlaidClient build() {
            if (this.baseUrl == null) {
                throw new IllegalArgumentException("must set baseUrl. You probably want to call productionBaseUrl(), developmentBaseUrl(), or sandboxBaseUrl().");
            }
            if (this.publicKey == null && (this.clientId == null || this.secret == null)) {
                throw new IllegalArgumentException("must set a publicKey, clientIdAndSecret, or both!");
            }
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).validateEagerly(true).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.buildGson())).client(this.buildOkHttpClient()).build();
            return new PlaidClient((PlaidApiService)retrofit.create(PlaidApiService.class), retrofit);
        }

        private Gson buildGson() {
            return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)new CredentialInjectingTypeAdapterFactory(this.publicKey, this.clientId, this.secret)).registerTypeAdapterFactory((TypeAdapterFactory)new RequiredFieldTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new ImmutableListStripUnknownEnumsTypeAdapterFactory()).registerTypeAdapter(TransactionsGetRequest.BaseOptions.class, (Object)new TransactionsBaseOptionsSerializer()).registerTypeAdapter(InvestmentsTransactionsGetRequest.BaseOptions.class, (Object)new InvestmentsTransactionsBaseOptionsSerializer()).create();
        }

        private OkHttpClient buildOkHttpClient() {
            if (this.httpLogLevel != null) {
                this.okHttpClientBuilder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(this.httpLogLevel));
            }
            this.checkRuntimeSupportsTls12(this.okHttpClientBuilder);
            return this.okHttpClientBuilder.build();
        }

        private void checkRuntimeSupportsTls12(OkHttpClient.Builder okHttpClientBuilder) {
            Socket testSslSocket = null;
            try {
                OkHttpClient testOkHttpClient = okHttpClientBuilder.build();
                testSslSocket = (SSLSocket)testOkHttpClient.sslSocketFactory().createSocket();
                if (CONNECTION_SPEC.isCompatible((SSLSocket)testSslSocket)) {
                    return;
                }
                if (!Arrays.asList(((SSLSocket)testSslSocket).getSupportedProtocols()).contains(TlsVersion.TLS_1_2.javaName())) {
                    throw new RuntimeException("This JRE's SSL implementation does not support TLSv1.2. Bailing out.");
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
                SSLContext sslContext = SSLContext.getInstance(TlsVersion.TLS_1_2.javaName());
                sslContext.init(null, new TrustManager[]{trustManager}, null);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                okHttpClientBuilder.sslSocketFactory(sslSocketFactory, trustManager);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (testSslSocket != null) {
                    try {
                        testSslSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public OkHttpClient.Builder okHttpClientBuilder() {
            return this.okHttpClientBuilder;
        }

        public Builder logLevel(HttpLoggingInterceptor.Level level) {
            this.httpLogLevel = level;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder productionBaseUrl() {
            return this.baseUrl(DEFAULT_PRODUCTION_BASE_URL);
        }

        public Builder sandboxBaseUrl() {
            return this.baseUrl(DEFAULT_SANDBOX_BASE_URL);
        }

        public Builder developmentBaseUrl() {
            return this.baseUrl(DEFAULT_DEVELOPMENT_BASE_URL);
        }

        public Builder publicKey(String publicKey) {
            Util.notNull(publicKey, "publicKey");
            this.publicKey = publicKey;
            return this;
        }

        public Builder clientIdAndSecret(String clientId, String secret) {
            Util.notNull(clientId, "clientId");
            Util.notNull(secret, "secret");
            this.clientId = clientId;
            this.secret = secret;
            return this;
        }
    }

    public static class PlaidApiHeadersInterceptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request transformedRequest = originalRequest.newBuilder().addHeader("Plaid-Version", "2019-05-29").addHeader("User-Agent", PlaidClient.getUserAgentHeader()).build();
            return chain.proceed(transformedRequest);
        }
    }
}

