/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.request.common.BaseClientRequest;
import com.plaid.client.request.common.BasePublicRequest;
import java.io.IOException;

public class CredentialInjectingTypeAdapterFactory
implements TypeAdapterFactory {
    private final String clientId;
    private final String publicKey;
    private final String secret;

    public CredentialInjectingTypeAdapterFactory(String publicKey, String clientId, String secret) {
        this.publicKey = publicKey;
        this.clientId = clientId;
        this.secret = secret;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final TypeAdapter defaultAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        if (BasePublicRequest.class.isAssignableFrom(type.getRawType())) {
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    if (CredentialInjectingTypeAdapterFactory.this.publicKey == null) {
                        throw new RuntimeException("publicKey was not provided, can't serialize!");
                    }
                    ((BasePublicRequest)value).publicKey = CredentialInjectingTypeAdapterFactory.this.publicKey;
                    defaultAdapter.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    return defaultAdapter.read(in);
                }
            };
        }
        if (BaseClientRequest.class.isAssignableFrom(type.getRawType())) {
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    if (CredentialInjectingTypeAdapterFactory.this.clientId == null) {
                        throw new RuntimeException("clientId was not provided, can't serialize!");
                    }
                    if (CredentialInjectingTypeAdapterFactory.this.secret == null) {
                        throw new RuntimeException("secret was not provided, can't serialize!");
                    }
                    ((BaseClientRequest)value).clientId = CredentialInjectingTypeAdapterFactory.this.clientId;
                    ((BaseClientRequest)value).secret = CredentialInjectingTypeAdapterFactory.this.secret;
                    defaultAdapter.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    return defaultAdapter.read(in);
                }
            };
        }
        return null;
    }
}

