/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import java.util.NoSuchElementException;

public final class Optional<T> {
    private static Optional<Object> EMPTY = new Optional<Object>(null);
    private final T value;

    private Optional(T value) {
        this.value = value;
    }

    public static <T, S extends T> Optional<T> of(S value) {
        if (value == null) {
            throw new IllegalArgumentException("Optional does not support NULL, use Optional.empty() instead.");
        }
        return new Optional<S>(value);
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public T get() {
        if (!this.isPresent()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Optional<T> orElse(T other) {
        if (this.isPresent()) {
            return this;
        }
        return Optional.of(other);
    }
}

