/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.plaid.client.internal.Util;
import com.plaid.client.request.common.BaseClientRequest;
import com.plaid.client.request.common.Product;
import java.util.List;

public final class InstitutionsGetRequest
extends BaseClientRequest {
    private Integer count;
    private Integer offset;
    private Options options;

    public InstitutionsGetRequest(Integer count, Integer offset) {
        Util.isBetween(count, 1, 500, "count");
        Util.isBetween(offset, 0, Integer.MAX_VALUE, "offset");
        this.count = count;
        this.offset = offset;
    }

    public InstitutionsGetRequest withProducts(List<Product> products) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.products = products;
        return this;
    }

    public InstitutionsGetRequest withIncludeOptionalMetadata(boolean includeOptionalMetadata) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.includeOptionalMetadata = includeOptionalMetadata;
        return this;
    }

    public InstitutionsGetRequest withCountryCodes(List<String> countryCodes) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.countryCodes = countryCodes;
        return this;
    }

    private static class Options {
        private List<Product> products;
        private boolean includeOptionalMetadata;
        private List<String> countryCodes;

        private Options() {
        }
    }
}

