/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImmutableListStripUnknownEnumsTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!List.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        Type actualTypeArgument = ((ParameterizedType)type.getType()).getActualTypeArguments()[0];
        final boolean isEnumType = actualTypeArgument instanceof Class && Enum.class.isAssignableFrom((Class)actualTypeArgument);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                Object value = delegate.read(in);
                if (value == null) {
                    return null;
                }
                List valueList = (List)value;
                if (isEnumType) {
                    ArrayList strippedList = new ArrayList(valueList.size());
                    for (Object enumValue : valueList) {
                        if (enumValue == null) continue;
                        strippedList.add(enumValue);
                    }
                    return Collections.unmodifiableList(strippedList);
                }
                return Collections.unmodifiableList(valueList);
            }
        };
    }
}

