/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class Util {
    public static void notNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " == null");
        }
    }

    public static void notEmpty(Collection collection, String name) {
        Util.notNull(collection, name);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
    }

    public static void notEmpty(Object[] arr, String name) {
        Util.notNull(arr, name);
        if (arr.length == 0) {
            throw new IllegalArgumentException(name + "must not be empty");
        }
    }

    public static void notEmpty(Map map, String name) {
        Util.notNull(map, name);
        if (map.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
    }

    public static void notBlank(String str, String name) {
        Util.notNull(str, name);
        if (str.trim().isEmpty()) {
            throw new IllegalArgumentException(name + " must not be blank");
        }
    }

    public static void isBetween(Integer value, int min, int max, String name) {
        Util.notNull(value, name);
        if (value < min || value > max) {
            throw new IllegalArgumentException(name + "(" + value + ") out of range: " + min + " <= " + name + " <= " + max);
        }
    }

    public static void isPositive(Integer value, String name) {
        Util.notNull(value, name);
        if (value < 0) {
            throw new IllegalArgumentException(name + "must be a positive number.");
        }
    }

    public static Map<String, String> arrayToMap(String[] args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Must pass in an even number of args, one key per value.");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            ret.put(args[i], args[i + 1]);
        }
        return ret;
    }
}

