/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateOnlyTypeAdapterFactory
implements TypeAdapterFactory {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Date.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        return new TypeAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(JsonWriter out, T value) throws IOException {
                SimpleDateFormat simpleDateFormat = DateOnlyTypeAdapterFactory.this.simpleDateFormat;
                synchronized (simpleDateFormat) {
                    out.value(DateOnlyTypeAdapterFactory.this.simpleDateFormat.format((Date)value));
                }
            }

            public T read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("read() is not implemented");
            }
        };
    }
}

