/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.internal.gson.Optional;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OptionalDateTypeAdapterFactory
implements TypeAdapterFactory {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.sss'Z'";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Optional.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        Type maybeDateType = ((ParameterizedType)type.getType()).getActualTypeArguments()[0];
        if (!Date.class.isAssignableFrom(TypeToken.get((Type)maybeDateType).getRawType())) {
            return null;
        }
        return new TypeAdapter<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(JsonWriter out, T value) throws IOException {
                if (((Optional)value).isPresent()) {
                    Date dateValue = (Date)((Optional)value).get();
                    SimpleDateFormat simpleDateFormat = OptionalDateTypeAdapterFactory.this.simpleDateFormat;
                    synchronized (simpleDateFormat) {
                        out.value(OptionalDateTypeAdapterFactory.this.simpleDateFormat.format(dateValue));
                    }
                } else {
                    out.nullValue();
                }
            }

            public T read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("read() is not implemented");
            }
        };
    }
}

