/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.internal.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.internal.gson.RequiredField;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class RequiredFieldTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!type.getRawType().isAssignableFrom(RequiredField.class)) {
            return null;
        }
        final TypeAdapter delegateAdapter = gson.getAdapter(TypeToken.get((Type)((ParameterizedType)type.getType()).getActualTypeArguments()[0]));
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                RequiredField requiredField = (RequiredField)value;
                if (requiredField == null || !requiredField.isPresent()) {
                    boolean oldSerializeNulls = out.getSerializeNulls();
                    out.setSerializeNulls(true);
                    out.nullValue();
                    out.setSerializeNulls(oldSerializeNulls);
                } else {
                    delegateAdapter.write(out, requiredField.get());
                }
            }

            public T read(JsonReader reader) throws IOException {
                return RequiredField.of(delegateAdapter.read(reader));
            }
        };
    }
}

