/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.plaid.client.internal.Util;
import com.plaid.client.request.common.BaseAccessTokenRequest;
import java.util.ArrayList;
import java.util.List;

public class AccountsBalanceGetRequest
extends BaseAccessTokenRequest {
    private Options options;

    public AccountsBalanceGetRequest(String accessToken) {
        super(accessToken);
    }

    public AccountsBalanceGetRequest withAccountIds(List<String> accountIds) {
        Util.notEmpty(accountIds, "accountIds");
        if (this.options == null) {
            this.options = new Options(new ArrayList<String>(accountIds));
        } else {
            this.options.setAccountIds(accountIds);
        }
        return this;
    }

    public AccountsBalanceGetRequest withMinLastUpdatedDateTime(String minLastUpdatedDatetime) {
        Util.notBlank(minLastUpdatedDatetime, "minLastUpdatedDatetime");
        if (this.options == null) {
            this.options = new Options(minLastUpdatedDatetime);
        } else {
            this.options.setMinLastUpdatedDateTime(minLastUpdatedDatetime);
        }
        return this;
    }

    private static class Options {
        private List<String> accountIds;
        private String minLastUpdatedDatetime;

        private Options(List<String> accountIds, String minLastUpdatedDatetime) {
            this.accountIds = accountIds;
            this.minLastUpdatedDatetime = minLastUpdatedDatetime;
        }

        private Options(List<String> accountIds) {
            this(accountIds, null);
        }

        private Options(String minLastUpdatedDatetime) {
            this(null, minLastUpdatedDatetime);
        }

        private void setMinLastUpdatedDateTime(String minLastUpdatedDatetime) {
            this.minLastUpdatedDatetime = minLastUpdatedDatetime;
        }

        private void setAccountIds(List<String> accountIds) {
            this.accountIds = accountIds;
        }
    }
}

