/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.request;

import com.plaid.client.internal.Util;
import com.plaid.client.internal.gson.RequiredField;
import com.plaid.client.request.common.BaseClientRequest;
import com.plaid.client.request.common.Product;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class InstitutionsSearchRequest
extends BaseClientRequest {
    private String query;
    private RequiredField<List<Product>> products = RequiredField.empty();
    private List<String> countryCodes;
    private Options options;

    public InstitutionsSearchRequest(String query, List<String> countryCodes) {
        Util.notNull(query, "query");
        Util.notEmpty(countryCodes, "countryCodes");
        this.query = query;
        this.countryCodes = countryCodes;
    }

    public InstitutionsSearchRequest withProducts(Product ... products) {
        Util.notEmpty((Object[])products, "product");
        if (!this.products.isPresent()) {
            this.products = RequiredField.of(new ArrayList());
        }
        this.products.get().addAll(Arrays.asList(products));
        return this;
    }

    public InstitutionsSearchRequest withIncludeOptionalMetadata(boolean includeOptionalMetadata) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.includeOptionalMetadata = includeOptionalMetadata;
        return this;
    }

    public InstitutionsSearchRequest withAccountFilter(Map<String, List<String>> accountFilter) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.accountFilter = accountFilter;
        return this;
    }

    public InstitutionsSearchRequest withOAuth(boolean oauth) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.oauth = oauth;
        return this;
    }

    public InstitutionsSearchRequest withIncludePaymentInitiationMetadata(boolean includePaymentInitiationMetadata) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.includePaymentInitiationMetadata = includePaymentInitiationMetadata;
        return this;
    }

    public InstitutionsSearchRequest withPaymentInitiation(PaymentInitiation paymentInitiation) {
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.paymentInitiation = paymentInitiation;
        return this;
    }

    private static class Options {
        private boolean includeOptionalMetadata;
        private Map<String, List<String>> accountFilter;
        private Boolean oauth;
        private boolean includePaymentInitiationMetadata;
        private PaymentInitiation paymentInitiation;

        private Options() {
        }
    }

    public static class PaymentInitiation {
        private String paymentId;

        public PaymentInitiation(String paymentId) {
            this.paymentId = paymentId;
        }
    }
}

