/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.response;

import com.plaid.client.response.BaseResponse;
import com.plaid.client.response.IdentityGetResponse;
import com.plaid.client.response.TransactionsGetResponse;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AssetReportGetResponse
extends BaseResponse {
    private AssetReport report;
    private List<Warning> warnings;

    public AssetReport getReport() {
        return this.report;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public static class AssetReport {
        private String assetReportId;
        private String clientReportId;
        private Date dateGenerated;
        private Integer daysRequested;
        private User user;
        private List<Item> items;

        public String getAssetReportId() {
            return this.assetReportId;
        }

        public String getClientReportId() {
            return this.clientReportId;
        }

        public Date getDateGenerated() {
            return this.dateGenerated;
        }

        public Integer getDaysRequested() {
            return this.daysRequested;
        }

        public User getUser() {
            return this.user;
        }

        public List<Item> getItems() {
            return this.items;
        }
    }

    public static class Error {
        private String errorType;
        private String errorCode;
        private String errorMessage;
        private String displayMessage;
        private Integer status;
        private List<Cause> causes;

        public String getErrorType() {
            return this.errorType;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getDisplayMessage() {
            return this.displayMessage;
        }

        public Integer getStatus() {
            return this.status;
        }

        public List<Cause> getCauses() {
            return this.causes;
        }
    }

    public static class Cause {
        private Error error;
        private String itemId;

        public Error getError() {
            return this.error;
        }

        public String getItemId() {
            return this.itemId;
        }
    }

    public static class Warning {
        private String warningType;
        private String warningCode;
        private Cause cause;

        public String getWarningType() {
            return this.warningType;
        }

        public String getWarningCode() {
            return this.warningCode;
        }

        public Cause getCause() {
            return this.cause;
        }
    }

    public static class Transaction {
        private String accountId;
        private String transactionId;
        private Date date;
        private String originalDescription;
        private String pending;
        private Double amount;
        private String unofficialCurrencyCode;
        private String isoCurrencyCode;
        private String accountOwner;
        private List<String> category;
        private String categoryId;
        private String dateTransacted;
        private TransactionsGetResponse.Transaction.Location location;
        private String name;
        private TransactionsGetResponse.Transaction.PaymentMeta paymentMeta;
        private String pendingTransactionId;
        private String transactionType;

        public String getAccountId() {
            return this.accountId;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public Date getDate() {
            return this.date;
        }

        public String getOriginalDescription() {
            return this.originalDescription;
        }

        public String getPending() {
            return this.pending;
        }

        public Double getAmount() {
            return this.amount;
        }

        public String getUnofficialCurrencyCode() {
            return this.unofficialCurrencyCode;
        }

        public String getIsoCurrencyCode() {
            return this.isoCurrencyCode;
        }

        public String getAccountOwner() {
            return this.accountOwner;
        }

        public List<String> getCategory() {
            return this.category;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public String getDateTransacted() {
            return this.dateTransacted;
        }

        public TransactionsGetResponse.Transaction.Location getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public TransactionsGetResponse.Transaction.PaymentMeta getPaymentMeta() {
            return this.paymentMeta;
        }

        public String getPendingTransactionId() {
            return this.pendingTransactionId;
        }

        public String getTransactionType() {
            return this.transactionType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Transaction that = (Transaction)obj;
            return Objects.equals(this.accountId, that.accountId) && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.date, that.date) && Objects.equals(this.originalDescription, that.originalDescription) && Objects.equals(this.pending, that.pending) && Objects.equals(this.amount, that.amount) && Objects.equals(this.unofficialCurrencyCode, that.unofficialCurrencyCode) && Objects.equals(this.isoCurrencyCode, that.isoCurrencyCode) && Objects.equals(this.accountOwner, that.accountOwner) && Objects.equals(this.category, that.category) && Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.dateTransacted, that.dateTransacted) && Objects.equals(this.location, that.location) && Objects.equals(this.name, that.name) && Objects.equals(this.paymentMeta, that.paymentMeta) && Objects.equals(this.pendingTransactionId, that.pendingTransactionId) && Objects.equals(this.transactionType, that.transactionType);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.transactionId, this.date, this.originalDescription, this.pending, this.amount, this.unofficialCurrencyCode, this.isoCurrencyCode, this.accountOwner, this.category, this.categoryId, this.dateTransacted, this.location, this.name, this.paymentMeta, this.pendingTransactionId, this.transactionType);
        }
    }

    public static class HistoricalBalance {
        private Date date;
        private Double current;
        private String unofficialCurrencyCode;
        private String isoCurrencyCode;

        public Date getDate() {
            return this.date;
        }

        public Double getCurrent() {
            return this.current;
        }

        public String getUnofficialCurrencyCode() {
            return this.unofficialCurrencyCode;
        }

        public String getIsoCurrencyCode() {
            return this.isoCurrencyCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalBalance that = (HistoricalBalance)obj;
            return Objects.equals(this.date, that.date) && Objects.equals(this.current, that.current) && Objects.equals(this.unofficialCurrencyCode, that.unofficialCurrencyCode) && Objects.equals(this.isoCurrencyCode, that.isoCurrencyCode);
        }

        public int hashCode() {
            return Objects.hash(this.date, this.current, this.unofficialCurrencyCode, this.isoCurrencyCode);
        }
    }

    public static class Balance {
        private Double avaliable;
        private Double current;
        private String unofficialCurrencyCode;
        private String isoCurrencyCode;

        public Double getAvaliable() {
            return this.avaliable;
        }

        public Double getCurrent() {
            return this.current;
        }

        public String getUnofficialCurrencyCode() {
            return this.unofficialCurrencyCode;
        }

        public String getIsoCurrencyCode() {
            return this.isoCurrencyCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Balance balance = (Balance)obj;
            return Objects.equals(this.avaliable, balance.avaliable) && Objects.equals(this.current, balance.current) && Objects.equals(this.unofficialCurrencyCode, balance.unofficialCurrencyCode) && Objects.equals(this.isoCurrencyCode, balance.isoCurrencyCode);
        }

        public int hashCode() {
            return Objects.hash(this.avaliable, this.current, this.unofficialCurrencyCode, this.isoCurrencyCode);
        }
    }

    public static class Owner {
        private List<String> names;
        private List<IdentityGetResponse.PhoneNumber> phoneNumbers;
        private List<IdentityGetResponse.Email> emails;
        private List<IdentityGetResponse.Address> addresses;

        public List<String> getNames() {
            return this.names;
        }

        public List<IdentityGetResponse.PhoneNumber> getPhoneNumbers() {
            return this.phoneNumbers;
        }

        public List<IdentityGetResponse.Email> getEmails() {
            return this.emails;
        }

        public List<IdentityGetResponse.Address> getAddresses() {
            return this.addresses;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Owner owner = (Owner)obj;
            return Objects.equals(this.names, owner.names) && Objects.equals(this.phoneNumbers, owner.phoneNumbers) && Objects.equals(this.emails, owner.emails) && Objects.equals(this.addresses, owner.addresses);
        }

        public int hashCode() {
            return Objects.hash(this.names, this.phoneNumbers, this.emails, this.addresses);
        }
    }

    public static class Account {
        private String accountId;
        private String mask;
        private String name;
        private String officialName;
        private String type;
        private String subtype;
        private List<Owner> owners;
        private Balance balances;
        private List<HistoricalBalance> historicalBalances;
        private List<Transaction> transactions;
        private Integer daysAvailable;

        public String getAccountId() {
            return this.accountId;
        }

        public String getMask() {
            return this.mask;
        }

        public String getName() {
            return this.name;
        }

        public String getOfficialName() {
            return this.officialName;
        }

        public String getType() {
            return this.type;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public List<Owner> getOwners() {
            return this.owners;
        }

        public Balance getBalances() {
            return this.balances;
        }

        public List<HistoricalBalance> getHistoricalBalances() {
            return this.historicalBalances;
        }

        public List<Transaction> getTransactions() {
            return this.transactions;
        }

        public Integer getDaysAvailable() {
            return this.daysAvailable;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Account account = (Account)obj;
            return Objects.equals(this.accountId, account.accountId) && Objects.equals(this.mask, account.mask) && Objects.equals(this.name, account.name) && Objects.equals(this.officialName, account.officialName) && Objects.equals(this.type, account.type) && Objects.equals(this.subtype, account.subtype) && Objects.equals(this.owners, account.owners) && Objects.equals(this.balances, account.balances) && Objects.equals(this.historicalBalances, account.historicalBalances) && Objects.equals(this.transactions, account.transactions) && Objects.equals(this.daysAvailable, account.daysAvailable);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.mask, this.name, this.officialName, this.type, this.subtype, this.owners, this.balances, this.historicalBalances, this.transactions, this.daysAvailable);
        }
    }

    public static class Item {
        private String itemId;
        private String institutionName;
        private String institutionId;
        private Date dateLastUpdated;
        private List<Account> accounts;

        public String getItemId() {
            return this.itemId;
        }

        public String getInstitutionName() {
            return this.institutionName;
        }

        public String getInstitutionId() {
            return this.institutionId;
        }

        public Date getDateLastUpdated() {
            return this.dateLastUpdated;
        }

        public List<Account> getAccounts() {
            return this.accounts;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Item item = (Item)obj;
            return Objects.equals(this.itemId, item.itemId) && Objects.equals(this.institutionName, item.institutionName) && Objects.equals(this.institutionId, item.institutionId) && Objects.equals(this.accounts, item.accounts);
        }

        public int hashCode() {
            return Objects.hash(this.itemId, this.institutionName, this.institutionId, this.accounts);
        }
    }

    public static class User {
        private String clientUserId;
        private String firstName;
        private String middleName;
        private String lastName;
        private String ssn;
        private String phoneNumber;
        private String email;

        public String getClientUserId() {
            return this.clientUserId;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getSsn() {
            return this.ssn;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            User user = (User)obj;
            return Objects.equals(this.clientUserId, user.clientUserId) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.middleName, user.middleName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.ssn, user.ssn) && Objects.equals(this.phoneNumber, user.phoneNumber) && Objects.equals(this.email, user.email);
        }

        public int hashCode() {
            return Objects.hash(this.clientUserId, this.firstName, this.middleName, this.lastName, this.ssn, this.phoneNumber, this.email);
        }
    }
}

