/*
 * Decompiled with CFR 0.152.
 */
package com.planet57.gossip.support;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DC {
    public static final String KEY = DC.getProperty("key", "DC");
    public static final String PREFIX = DC.getProperty("prefix", ",");
    public static final String SEPARATOR = DC.getProperty("separator", ",");
    private static InheritableThreadLocal<State> stateHolder = new InheritableThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }

        @Override
        protected State childValue(State parentValue) {
            return new State(parentValue);
        }
    };

    private static State state() {
        return (State)stateHolder.get();
    }

    private static Map<String, String> map() {
        return DC.state().map;
    }

    private static LinkedList<String> stack() {
        return DC.state().stack;
    }

    public static State getState() {
        return new State(DC.state());
    }

    public static void setState(State state) {
        DC.checkNotNull(state);
        stateHolder.set(state);
        DC.update();
    }

    public static void reset() {
        stateHolder.remove();
        MDC.remove((String)KEY);
    }

    public static StringBuilder render() {
        State state = DC.state();
        StringBuilder buff = new StringBuilder();
        if (!state.stack.isEmpty()) {
            buff.append(state.stack);
        }
        if (!state.map.isEmpty()) {
            if (buff.length() != 0) {
                buff.append(SEPARATOR);
            }
            buff.append(state.map);
        }
        return buff;
    }

    private static void update() {
        StringBuilder buff = DC.render();
        if (buff.length() != 0) {
            buff.insert(0, PREFIX);
            MDC.put((String)KEY, (String)buff.toString());
        } else {
            DC.reset();
        }
    }

    public static void put(Object key, Object value) {
        DC.checkNotNull(key);
        DC.map().put(key.toString(), String.valueOf(value));
        DC.update();
    }

    public static void put(Class key, Object value) {
        DC.checkNotNull(key);
        DC.put(key.getSimpleName(), value);
    }

    public static RestoreHandle install(Object key, Object value) {
        DC.checkNotNull(key);
        final String _key = String.valueOf(key);
        final Map<String, String> map = DC.map();
        final boolean exists = map.containsKey(_key);
        final String prev = DC.map().put(_key, String.valueOf(value));
        DC.update();
        return new RestoreHandle(){

            public void restore() {
                if (exists) {
                    map.put(_key, String.valueOf(prev));
                } else {
                    map.remove(_key);
                }
                DC.update();
            }
        };
    }

    public static RestoreHandle install(Class key, Object value) {
        DC.checkNotNull(key);
        return DC.install(key.getSimpleName(), value);
    }

    public static String get(Object key) {
        DC.checkNotNull(key);
        return DC.map().get(key.toString());
    }

    public static String get(Class key) {
        DC.checkNotNull(key);
        return DC.get(key.getSimpleName());
    }

    public static void remove(Object key) {
        DC.checkNotNull(key);
        DC.map().remove(key.toString());
        DC.update();
    }

    public static void remove(Class key) {
        DC.checkNotNull(key);
        DC.remove(key.getSimpleName());
    }

    public static void push(Object value) {
        DC.checkNotNull(value);
        DC.stack().addFirst(value.toString());
        DC.update();
    }

    public static String pop() {
        String value = DC.stack().removeFirst();
        DC.update();
        return value;
    }

    public static String peek() {
        return DC.stack().peek();
    }

    private static String getProperty(String name, String defaultValue) {
        return System.getProperty(DC.class.getName() + "." + name, defaultValue);
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static interface RestoreHandle {
        public void restore();
    }

    public static class State {
        private final Map<String, String> map = new HashMap<String, String>();
        private final LinkedList<String> stack = new LinkedList();

        private State() {
        }

        private State(State source) {
            this();
            DC.checkNotNull(source);
            this.map.putAll(source.map);
            this.stack.addAll(source.stack);
        }

        public String toString() {
            return "State{map=" + this.map + ", stack=" + this.stack + '}';
        }
    }
}

