/*
 * Decompiled with CFR 0.152.
 */
package com.planet57.gossip.support;

import com.planet57.gossip.Event;
import com.planet57.gossip.Level;
import com.planet57.gossip.LoggerSupport;
import com.planet57.gossip.render.PatternRenderer;
import com.planet57.gossip.render.Renderer;
import java.io.PrintStream;

public class PrintStreamLogger
extends LoggerSupport {
    private final PrintStream stream;
    private volatile Level threshold;
    private volatile Renderer renderer;

    public PrintStreamLogger(PrintStream stream, Level threshold) {
        if (stream == null) {
            throw new NullPointerException();
        }
        this.stream = stream;
        this.threshold = threshold;
        this.setRenderer(this.createRenderer());
    }

    public PrintStreamLogger(PrintStream stream) {
        this(stream, null);
    }

    protected Renderer createRenderer() {
        return new PatternRenderer();
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public Level getThreshold() {
        if (this.threshold == null) {
            return Level.TRACE;
        }
        return this.threshold;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        if (renderer == null) {
            throw new NullPointerException();
        }
        this.renderer = renderer;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected boolean isEnabled(Level level) {
        assert (level != null);
        return this.getThreshold().id <= level.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLog(Event event) {
        PrintStream out;
        assert (event != null);
        PrintStream printStream = out = this.getStream();
        synchronized (printStream) {
            out.print(this.getRenderer().render(event));
            out.flush();
        }
    }
}

