/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.builder;

import com.platformlib.process.configurator.ProcessDryRunConfigurator;
import com.platformlib.process.configurator.ProcessInstanceConfigurator;
import com.platformlib.process.configurator.ProcessLoggerConfigurator;
import com.platformlib.process.executor.ProcessExecutor;
import com.platformlib.process.handler.ProcessDestroyerHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ProcessBuilder {
    public static final String EXE_EXTENSION = "exe";
    public static final String BAT_EXTENSION = "bat";
    public static final String CMD_EXTENSION = "cmd";
    public static final String BASH_EXTENSION = "bash";
    public static final String SH_EXTENSION = "sh";

    public ProcessBuilder name(String var1);

    public ProcessBuilder defaultExtensionMapping();

    public ProcessBuilder mapBashExtension();

    public ProcessBuilder mapShExtension();

    public ProcessBuilder mapBatExtension();

    public ProcessBuilder mapCmdExtension();

    public ProcessBuilder mapExeExtension();

    public ProcessBuilder stdOutConsumer(Consumer<String> var1);

    public ProcessBuilder stdErrConsumer(Consumer<String> var1);

    public ProcessBuilder standardInput(InputStream var1);

    public ProcessBuilder command(String var1);

    public ProcessBuilder commandAndArguments(Object ... var1);

    public ProcessBuilder workDirectory(String var1);

    public ProcessBuilder workDirectory(Path var1);

    public ProcessBuilder envVariables(Map<String, String> var1);

    public ProcessBuilder withExecutor(Executor var1);

    public ProcessBuilder executionTimeout(Duration var1);

    public ProcessBuilder addMaskApplier(Function<String, String> var1);

    public ProcessBuilder redirectStandardOutput(OutputStream var1);

    public ProcessBuilder redirectStandardError(OutputStream var1);

    public ProcessBuilder rawExecution();

    public ProcessBuilder processDestroyerHandler(ProcessDestroyerHandler var1);

    public ProcessBuilder dryRun(Consumer<ProcessDryRunConfigurator> var1);

    public ProcessBuilder logger(Consumer<ProcessLoggerConfigurator> var1);

    public ProcessBuilder processInstance(Consumer<ProcessInstanceConfigurator> var1);

    public ProcessExecutor build();
}

