/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.builder.impl;

import com.platformlib.process.builder.ProcessBuilder;
import com.platformlib.process.configuration.ProcessConfiguration;
import com.platformlib.process.configuration.dryrun.ProcessDryRunConfiguration;
import com.platformlib.process.configuration.instance.ProcessInstanceConfiguration;
import com.platformlib.process.configuration.logger.ProcessLoggerConfiguration;
import com.platformlib.process.configurator.ProcessDryRunConfigurator;
import com.platformlib.process.configurator.ProcessInstanceConfigurator;
import com.platformlib.process.configurator.ProcessLoggerConfigurator;
import com.platformlib.process.configurator.impl.DefaultProcessDryRunConfigurator;
import com.platformlib.process.configurator.impl.DefaultProcessInstanceConfigurator;
import com.platformlib.process.configurator.impl.DefaultProcessLoggerConfigurator;
import com.platformlib.process.enums.ExecutionMode;
import com.platformlib.process.handler.ProcessDestroyerHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class DefaultProcessBuilder
implements ProcessBuilder,
ProcessConfiguration {
    private String name = Thread.currentThread().getName();
    private final Collection<String> winExtensionMapping = new LinkedList<String>();
    private final Collection<String> nixExtensionMapping = new LinkedList<String>();
    private Consumer<String> stdOutConsumer;
    private Consumer<String> stdErrConsumer;
    private Duration executionTimeout;
    private String command;
    private final Collection<Object> commandAndArguments = new ArrayList<Object>();
    private boolean rawExecution = true;
    private ProcessDestroyerHandler processDestroyerHandler;
    private InputStream processStandardInputStream;
    private OutputStream stdOutRedirectStream;
    private OutputStream stdErrRedirectStream;
    private Object workDirectory;
    private Executor executor;
    private DefaultProcessDryRunConfigurator processDryRunConfigurator;
    private final Map<String, String> envVariables = new ConcurrentHashMap<String, String>();
    private final Collection<Function<String, String>> maskAppliers = new ArrayList<Function<String, String>>();
    private final DefaultProcessLoggerConfigurator processLoggerConfigurator = new DefaultProcessLoggerConfigurator();
    private final DefaultProcessInstanceConfigurator processInstanceConfigurator = new DefaultProcessInstanceConfigurator();
    private final Map<Class<?>, Function<Object, String>> loggerArgumentFunctionsMap = new ConcurrentHashMap();
    private final Map<Class<?>, Function<Object, String>> argumentFunctionsMap = new ConcurrentHashMap();

    @Override
    public DefaultProcessBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DefaultProcessBuilder workDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
        return this;
    }

    @Override
    public DefaultProcessBuilder workDirectory(Path workDirectory) {
        this.workDirectory = workDirectory;
        return this;
    }

    @Override
    public DefaultProcessBuilder envVariables(Map<String, String> envVariables) {
        this.envVariables.putAll(envVariables);
        return this;
    }

    @Override
    public DefaultProcessBuilder defaultExtensionMapping() {
        this.winExtensionMapping.add("cmd");
        this.winExtensionMapping.add("bat");
        this.winExtensionMapping.add("exe");
        this.nixExtensionMapping.add("sh");
        this.nixExtensionMapping.add("bash");
        return this;
    }

    @Override
    public DefaultProcessBuilder mapBashExtension() {
        this.winExtensionMapping.add("bash");
        return this;
    }

    @Override
    public DefaultProcessBuilder mapShExtension() {
        this.nixExtensionMapping.add("sh");
        return this;
    }

    @Override
    public DefaultProcessBuilder mapBatExtension() {
        this.winExtensionMapping.add("bat");
        return this;
    }

    @Override
    public DefaultProcessBuilder mapCmdExtension() {
        this.winExtensionMapping.add("cmd");
        return this;
    }

    @Override
    public DefaultProcessBuilder mapExeExtension() {
        this.winExtensionMapping.add("exe");
        return this;
    }

    @Override
    public DefaultProcessBuilder stdOutConsumer(Consumer<String> stdOutConsumer) {
        this.stdOutConsumer = stdOutConsumer;
        return this;
    }

    @Override
    public DefaultProcessBuilder stdErrConsumer(Consumer<String> stdErrConsumer) {
        this.stdErrConsumer = stdErrConsumer;
        return this;
    }

    @Override
    public DefaultProcessBuilder standardInput(InputStream processStandardInputStream) {
        this.processStandardInputStream = processStandardInputStream;
        return this;
    }

    @Override
    public DefaultProcessBuilder command(String command) {
        this.command = Objects.requireNonNull(command);
        return this;
    }

    @Override
    public DefaultProcessBuilder commandAndArguments(Object ... commandAndArguments) {
        Objects.requireNonNull(commandAndArguments);
        for (int i = 0; i < commandAndArguments.length; ++i) {
            Objects.requireNonNull(commandAndArguments[i], "Command line/arguments is null at " + i);
        }
        Collections.addAll(this.commandAndArguments, commandAndArguments);
        return this;
    }

    @Override
    public DefaultProcessBuilder withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public DefaultProcessBuilder executionTimeout(Duration timeout) {
        this.executionTimeout = timeout;
        return this;
    }

    @Override
    public DefaultProcessBuilder addMaskApplier(Function<String, String> maskApplier) {
        this.maskAppliers.add(maskApplier);
        return this;
    }

    @Override
    public DefaultProcessBuilder redirectStandardOutput(OutputStream outputStream) {
        this.stdOutRedirectStream = outputStream;
        return this;
    }

    @Override
    public DefaultProcessBuilder redirectStandardError(OutputStream outputStream) {
        this.stdErrRedirectStream = outputStream;
        return this;
    }

    @Override
    public DefaultProcessBuilder rawExecution() {
        this.rawExecution = true;
        return this;
    }

    @Override
    public DefaultProcessBuilder processDestroyerHandler(ProcessDestroyerHandler processDestroyerHandler) {
        this.processDestroyerHandler = processDestroyerHandler;
        return this;
    }

    @Override
    public DefaultProcessBuilder dryRun(Consumer<ProcessDryRunConfigurator> processDryRunConfigurator) {
        if (this.processDryRunConfigurator == null) {
            this.processDryRunConfigurator = new DefaultProcessDryRunConfigurator();
        }
        processDryRunConfigurator.accept(this.processDryRunConfigurator);
        return this;
    }

    @Override
    public Collection<Function<String, String>> getMaskAppliers() {
        return this.maskAppliers;
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public Optional<String> getWorkDirectory() {
        return Optional.ofNullable(this.workDirectory).map(Object::toString);
    }

    @Override
    public Optional<Executor> getExecutor() {
        return Optional.ofNullable(this.executor);
    }

    @Override
    public Optional<Duration> getExecutionTimeout() {
        return Optional.ofNullable(this.executionTimeout);
    }

    @Override
    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    @Override
    public Optional<Consumer<String>> getStdOutConsumer() {
        return Optional.ofNullable(this.stdOutConsumer);
    }

    @Override
    public Optional<Consumer<String>> getStdErrConsumer() {
        return Optional.ofNullable(this.stdErrConsumer);
    }

    @Override
    public Collection<Object> getCommandAndArguments() {
        ArrayList<Object> cla = new ArrayList<Object>();
        if (this.command != null) {
            cla.add(this.command);
        }
        cla.addAll(this.commandAndArguments);
        return cla;
    }

    @Override
    public Collection<OutputStream> getStandardOutputRedirects() {
        return this.stdOutRedirectStream == null ? Collections.emptyList() : Collections.singleton(this.stdOutRedirectStream);
    }

    @Override
    public Collection<OutputStream> getStandardErrorRedirects() {
        return this.stdErrRedirectStream == null ? Collections.emptyList() : Collections.singleton(this.stdErrRedirectStream);
    }

    @Override
    public ExecutionMode getExecution() {
        return this.rawExecution ? ExecutionMode.RAW : ExecutionMode.NORMAL;
    }

    @Override
    public Optional<InputStream> getStdIn() {
        return Optional.ofNullable(this.processStandardInputStream);
    }

    @Override
    public Optional<ProcessDestroyerHandler> getProcessDestroyerHandler() {
        return Optional.ofNullable(this.processDestroyerHandler);
    }

    @Override
    public Optional<ProcessDryRunConfiguration> getDryRunConfiguration() {
        return Optional.ofNullable(this.processDryRunConfigurator);
    }

    @Override
    public DefaultProcessBuilder logger(Consumer<ProcessLoggerConfigurator> processLoggerConfigurator) {
        processLoggerConfigurator.accept(this.processLoggerConfigurator);
        return this;
    }

    @Override
    public DefaultProcessBuilder processInstance(Consumer<ProcessInstanceConfigurator> processInstanceConfigurator) {
        processInstanceConfigurator.accept(this.processInstanceConfigurator);
        return this;
    }

    protected Optional<String> getCommand() {
        return Optional.ofNullable(this.command);
    }

    @Override
    public Optional<ProcessInstanceConfiguration> getProcessInstanceConfiguration() {
        return Optional.ofNullable(this.processInstanceConfigurator);
    }

    @Override
    public Optional<ProcessLoggerConfiguration> getProcessLoggerConfiguration() {
        return Optional.ofNullable(this.processLoggerConfigurator);
    }
}

