/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.configurator.impl;

import com.platformlib.process.configuration.logger.ProcessInputLoggerConfiguration;
import com.platformlib.process.configuration.logger.ProcessLoggerConfiguration;
import com.platformlib.process.configuration.logger.ProcessOutputLoggerConfiguration;
import com.platformlib.process.configurator.ProcessInputLoggerConfigurator;
import com.platformlib.process.configurator.ProcessLoggerConfigurator;
import com.platformlib.process.configurator.ProcessOutputLoggerConfigurator;
import com.platformlib.process.configurator.impl.DefaultProcessInputLoggerConfigurator;
import com.platformlib.process.configurator.impl.DefaultProcessOutputLoggerConfigurator;
import com.platformlib.process.initializer.ProcessThreadInitializer;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class DefaultProcessLoggerConfigurator
extends DefaultProcessOutputLoggerConfigurator
implements ProcessLoggerConfigurator,
ProcessLoggerConfiguration {
    private ProcessThreadInitializer processThreadInitializer;
    private DefaultProcessInputLoggerConfigurator stdInLoggerConfigurator = new DefaultProcessInputLoggerConfigurator();
    private DefaultProcessOutputLoggerConfigurator stdOutLoggerConfigurator = new DefaultProcessOutputLoggerConfigurator();
    private DefaultProcessOutputLoggerConfigurator stdErrLoggerConfigurator = new DefaultProcessOutputLoggerConfigurator();

    @Override
    public void logger(Logger logger) {
        super.logger(logger);
        if (!this.stdOutLoggerConfigurator.getLogger().isPresent()) {
            this.stdOutLoggerConfigurator.logger(logger);
        }
        if (!this.stdErrLoggerConfigurator.getLogger().isPresent()) {
            this.stdErrLoggerConfigurator.logger(logger);
        }
        if (!this.stdInLoggerConfigurator.getLogger().isPresent()) {
            this.stdInLoggerConfigurator.logger(logger);
        }
    }

    @Override
    public Optional<ProcessInputLoggerConfiguration> getLoggerStdInConfiguration() {
        return Optional.of(this.stdInLoggerConfigurator);
    }

    @Override
    public Optional<ProcessOutputLoggerConfiguration> getLoggerStdOutConfiguration() {
        return Optional.ofNullable(this.stdOutLoggerConfigurator);
    }

    @Override
    public Optional<ProcessOutputLoggerConfiguration> getLoggerStdErrConfiguration() {
        return Optional.ofNullable(this.stdErrLoggerConfigurator);
    }

    @Override
    public Optional<ProcessThreadInitializer> getProcessThreadInitializer() {
        return Optional.ofNullable(this.processThreadInitializer);
    }

    @Override
    public void stdIn(Consumer<ProcessInputLoggerConfigurator> stdInLoggerConfigurator) {
    }

    @Override
    public void stdOut(Consumer<ProcessOutputLoggerConfigurator> stdOutLoggerConfigurator) {
        stdOutLoggerConfigurator.accept(this.stdOutLoggerConfigurator);
    }

    @Override
    public void stdErr(Consumer<ProcessOutputLoggerConfigurator> stdErrLoggerConfigurator) {
        stdErrLoggerConfigurator.accept(this.stdErrLoggerConfigurator);
    }

    @Override
    public void onProcessThreadStart(ProcessThreadInitializer onProcessThreadStartPayload) {
        this.processThreadInitializer = onProcessThreadStartPayload;
    }
}

