/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.core;

import com.platformlib.process.configuration.logger.ProcessOutputLoggerConfiguration;
import com.platformlib.process.core.DefaultProcessOutput;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProcessOutputListener
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessOutputListener.class);
    private static final int BUFFER_SIZE = 8192;
    private final byte[] readBytesBuffer = new byte[8192];
    private InputStream inputStream = null;
    private final CountDownLatch runLatch = new CountDownLatch(1);
    private final CountDownLatch completeLatch = new CountDownLatch(1);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(30L);
    private final Executor executor;
    private final String name;
    private final Function<String, String> stdOutFirstLineFunction;
    private boolean firstLineConsumed;
    private final DefaultProcessOutput processOutput;
    private final boolean outputAcceptReady;
    private final ProcessOutputLoggerConfiguration processOutputLoggerConfiguration;
    private final CycledBuffer<String> tailBuffer;
    private int headProcessed;

    public AsyncProcessOutputListener(Executor executor, String name, ProcessOutputLoggerConfiguration processOutputLoggerConfiguration, DefaultProcessOutput processOutput) {
        this(executor, name, processOutputLoggerConfiguration, processOutput, null);
    }

    public AsyncProcessOutputListener(Executor executor, String name, ProcessOutputLoggerConfiguration processOutputLoggerConfiguration, DefaultProcessOutput processOutput, Function<String, String> stdOutFirstLineFunction) {
        this.executor = executor;
        this.name = name;
        this.processOutputLoggerConfiguration = Objects.requireNonNull(processOutputLoggerConfiguration);
        this.processOutput = processOutput;
        executor.execute(this);
        this.stdOutFirstLineFunction = stdOutFirstLineFunction;
        this.outputAcceptReady = processOutput.isAcceptReady();
        this.tailBuffer = processOutputLoggerConfiguration.getTailSize().orElse(0) > 0 ? new CycledBuffer(processOutputLoggerConfiguration.getTailSize().get()) : null;
    }

    public void startListening(InputStream inputStream) {
        this.inputStream = inputStream;
        this.runLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        try {
            this.runLatch.await();
            LOGGER.trace("[{}] Start process output listening", (Object)this.name);
            while (this.inputStream != null) {
                int len = this.inputStream.read(this.readBytesBuffer);
                if (len < 0) {
                    byteBuffer.flip();
                    if (byteBuffer.hasRemaining()) {
                        this.consumeLine(this.name, byteBuffer);
                    }
                    byteBuffer.clear();
                    break;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("[{}] Read {} byte(s) {}", new Object[]{this.name, len, Arrays.copyOf(this.readBytesBuffer, len)});
                }
                if (len > 0) {
                    for (OutputStream outputStream : this.processOutput.getOutputStreams()) {
                        outputStream.write(this.readBytesBuffer, 0, len);
                    }
                }
                for (int i = 0; i < len; ++i) {
                    if (this.readBytesBuffer[i] == 10) {
                        byteBuffer.flip();
                        if (this.stdOutFirstLineFunction != null && !this.firstLineConsumed) {
                            this.firstLineConsumed = true;
                            String firstLine = AsyncProcessOutputListener.getStringLine(byteBuffer);
                            String appliedLine = this.stdOutFirstLineFunction.apply(firstLine);
                            if (appliedLine != null) {
                                this.consumeLine(this.name, appliedLine);
                            } else {
                                LOGGER.trace("First line consumer accepted: {}", (Object)firstLine);
                            }
                        } else {
                            this.consumeLine(this.name, byteBuffer);
                        }
                        byteBuffer.clear();
                        continue;
                    }
                    if (this.readBytesBuffer[i] == 13) continue;
                    if (byteBuffer.remaining() > 0) {
                        byteBuffer.put(this.readBytesBuffer[i]);
                        continue;
                    }
                    byteBuffer.flip();
                    String line = AsyncProcessOutputListener.getStringLine(byteBuffer) + "<<No new line break>>";
                    LOGGER.warn(line);
                    this.consumeLine(this.name, line);
                    byteBuffer.clear();
                    byteBuffer.put(this.readBytesBuffer[i]);
                }
            }
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            LOGGER.error("[" + this.name + "] Fail to read channel", (Throwable)exception);
            byteBuffer.flip();
            if (byteBuffer.hasRemaining()) {
                this.consumeLine(this.name, byteBuffer);
            }
            byteBuffer.clear();
        }
        finally {
            this.completeLatch.countDown();
            LOGGER.trace("[{}] Stop process output listening", (Object)this.name);
        }
    }

    private static String getStringLine(ByteBuffer byteBuffer) {
        return new String(byteBuffer.array(), 0, byteBuffer.remaining(), StandardCharsets.UTF_8);
    }

    private void consumeLine(String name, ByteBuffer byteBuffer) {
        this.consumeLine(name, AsyncProcessOutputListener.getStringLine(byteBuffer));
    }

    private void consumeLine(String name, String line) {
        if (this.processOutputLoggerConfiguration.getLogger().orElse(LOGGER) == LOGGER && LOGGER.isTraceEnabled()) {
            LOGGER.trace("[{}] Process output: {}", (Object)name, (Object)line);
            return;
        }
        if (!this.processOutputLoggerConfiguration.getHeadSize().isPresent() && !this.processOutputLoggerConfiguration.getTailSize().isPresent()) {
            this.processOutputLoggerConfiguration.getLogger().ifPresent(logger -> logger.debug("[{}] Process output: {}", (Object)name, (Object)line));
        } else if (this.processOutputLoggerConfiguration.getHeadSize().isPresent() && (this.processOutputLoggerConfiguration.getHeadSize().get() < 0 || this.headProcessed < this.processOutputLoggerConfiguration.getHeadSize().get())) {
            ++this.headProcessed;
            this.processOutputLoggerConfiguration.getLogger().orElse(LOGGER).debug("[{}] Process output: {}", (Object)name, (Object)line);
        } else if (this.processOutputLoggerConfiguration.getTailSize().orElse(0) > 0) {
            this.tailBuffer.add(line);
        }
        if (this.outputAcceptReady) {
            this.processOutput.accept(line);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.completeLatch.await(SHUTDOWN_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.processOutputLoggerConfiguration.getLogger().orElse(LOGGER).debug("[{}] Process output listener wasn't shut down due to timeout", (Object)this.name);
        }
        if (this.tailBuffer != null) {
            this.tailBuffer.getValues().forEach(line -> this.processOutputLoggerConfiguration.getLogger().orElse(LOGGER).debug("[{}] Process output: {}", (Object)this.name, line));
        }
        this.runLatch.countDown();
        for (OutputStream outputStream : this.processOutput.getOutputStreams()) {
            outputStream.flush();
            outputStream.close();
        }
        this.inputStream = null;
    }

    private static class CycledBuffer<T> {
        private int position;
        private final Object[] items;

        CycledBuffer(int size) {
            this.items = new Object[size];
        }

        void add(T item) {
            this.items[this.position++ % this.items.length] = item;
        }

        Collection<T> getValues() {
            int len = Math.min(this.position, this.items.length);
            ArrayList<Object> result = new ArrayList<Object>(len);
            int resultPosition = this.position - len;
            for (int i = 0; i < len; ++i) {
                result.add(this.items[resultPosition++ % this.items.length]);
            }
            return result;
        }
    }
}

