/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.core;

import com.platformlib.process.api.OperationSystemProcess;
import com.platformlib.process.api.ProcessInstance;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;

public class DefaultOperationSystemProcess
extends CompletableFuture<ProcessInstance>
implements OperationSystemProcess {
    private final CountDownLatch pidCountDownLatch = new CountDownLatch(1);
    private Integer pid = null;

    public void setPid(Integer pid) {
        this.pid = pid;
        this.pidCountDownLatch.countDown();
    }

    @Override
    public Optional<Integer> getPid() {
        try {
            this.pidCountDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return Optional.ofNullable(this.pid);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.pidCountDownLatch.countDown();
        return super.completeExceptionally(ex);
    }

    @Override
    public boolean complete(ProcessInstance value) {
        this.pidCountDownLatch.countDown();
        return super.complete(value);
    }
}

