/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.core;

import com.platformlib.process.api.ProcessInstance;
import com.platformlib.process.core.ProcessOutput;
import com.platformlib.process.exception.OutputOverflowException;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultProcessInstance
implements ProcessInstance {
    private final int exitCode;
    private final Collection<String> stdOut;
    private final boolean stdOutOverflow;
    private final Collection<String> stdErr;
    private final boolean stdErrOverflow;

    public DefaultProcessInstance(int exitCode, ProcessOutput processStdOut, ProcessOutput processStdErr) {
        this.exitCode = exitCode;
        this.stdOut = new ArrayList<String>(processStdOut.getOutput());
        this.stdOutOverflow = processStdOut.isOverflowed();
        this.stdErr = new ArrayList<String>(processStdErr.getOutput());
        this.stdErrOverflow = processStdErr.isOverflowed();
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Collection<String> getStdOut() {
        if (this.stdOutOverflow) {
            throw new OutputOverflowException();
        }
        return this.stdOut;
    }

    @Override
    public Collection<String> getStdErr() {
        if (this.stdErrOverflow) {
            throw new OutputOverflowException();
        }
        return this.stdErr;
    }
}

