/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.core;

import com.platformlib.process.configuration.output.ProcessOutputConfiguration;
import com.platformlib.process.core.ProcessOutput;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultProcessOutput
implements ProcessOutput,
Consumer<String> {
    private final Collection<OutputStream> outputStreams;
    private final Consumer<String> lineConsumer;
    private final Queue<String> headMax;
    private final Queue<String> tailMax;
    private final int headSize;
    private final int tailSize;

    public DefaultProcessOutput(Collection<OutputStream> outputStreams, Consumer<String> lineConsumer, ProcessOutputConfiguration outputConfiguration) {
        this.outputStreams = outputStreams;
        this.lineConsumer = lineConsumer;
        this.headSize = outputConfiguration == null ? 0 : outputConfiguration.getHeadSize().orElse(0);
        this.tailSize = outputConfiguration == null ? 0 : outputConfiguration.getTailSize().orElse(0);
        this.headMax = new LimitedQueue<String>(this.headSize);
        this.tailMax = new LimitedQueue<String>(this.tailSize > 0 ? this.tailSize + 1 : this.tailSize);
    }

    public Collection<OutputStream> getOutputStreams() {
        return this.outputStreams;
    }

    public boolean isAcceptReady() {
        return this.headSize != 0 || this.tailSize != 0 || this.lineConsumer != null;
    }

    @Override
    public void accept(String s) {
        if (this.headSize < 0 || this.headSize > 0 && this.headMax.size() < this.headSize) {
            this.headMax.offer(s);
        } else if (this.tailSize != 0) {
            this.tailMax.offer(s);
        }
        if (this.lineConsumer != null) {
            this.lineConsumer.accept(s);
        }
    }

    @Override
    public boolean isOverflowed() {
        return (this.headSize > 0 || this.tailSize > 0) && Math.max(this.headSize, 0) + Math.max(this.tailSize, 0) < this.headMax.size() + this.tailMax.size();
    }

    @Override
    public Collection<String> getOutput() {
        return Stream.concat(this.headMax.stream(), this.tailMax.stream().skip(this.tailSize > 0 && this.tailMax.size() > this.tailSize ? 1L : 0L)).collect(Collectors.toList());
    }

    private static class LimitedQueue<E>
    extends LinkedList<E> {
        private final int limit;

        LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E e) {
            if (this.limit > 0 && super.size() == this.limit) {
                super.remove();
            }
            return super.add(e);
        }
    }
}

