/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.core;

import com.platformlib.process.api.MaskedValue;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class MaskedPassword
implements MaskedValue {
    private final byte[] value;
    private boolean destroyed;

    public static MaskedPassword of(String value) {
        return new MaskedPassword(value.getBytes(Charset.defaultCharset()));
    }

    public MaskedPassword(byte[] value) {
        this.value = new byte[value.length];
        System.arraycopy(value, 0, this.value, 0, value.length);
    }

    @Override
    public String getSourceValue() {
        return new String(this.value, Charset.defaultCharset());
    }

    public String toString() {
        return "*****";
    }

    @Override
    public void destroy() {
        Arrays.fill(this.value, (byte)0);
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

