/*
 * Decompiled with CFR 0.152.
 */
package com.platformlib.process.executor;

import com.platformlib.process.configuration.ProcessConfiguration;
import com.platformlib.process.configuration.dryrun.ProcessDryRunConfiguration;
import com.platformlib.process.configuration.instance.ProcessInstanceConfiguration;
import com.platformlib.process.configuration.logger.ProcessThreadLoggerConfiguration;
import com.platformlib.process.core.DefaultProcessOutput;
import com.platformlib.process.executor.ProcessExecutor;
import com.platformlib.process.handler.ProcessDestroyerHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultProcessExecutor
implements ProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProcessExecutor.class);
    private static final AtomicLong EXECUTION_COUNTER = new AtomicLong(0L);
    private final long executionId = EXECUTION_COUNTER.incrementAndGet();
    private final ProcessConfiguration processConfiguration;
    private final ExecutorService executorService;
    private PipedInputStream stdOutPipedInputStream = null;
    private PipedOutputStream stdOutPipedOutputStream = null;
    private PipedInputStream stdErrPipedInputStream = null;
    private PipedOutputStream stdErrPipedOutputStream = null;
    private final DefaultProcessOutput processStdOut;
    private final DefaultProcessOutput processStdErr;

    public DefaultProcessExecutor(ProcessConfiguration processConfiguration) {
        this.processConfiguration = processConfiguration;
        this.executorService = processConfiguration.getExecutor().isPresent() ? null : Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r, "process-exec-" + processConfiguration.getName().map(name -> name + "-" + this.executionId).orElseGet(() -> String.valueOf(this.executionId)));
            thread.setDaemon(true);
            return thread;
        });
        this.processStdOut = new DefaultProcessOutput(processConfiguration.getStandardOutputRedirects(), processConfiguration.getStdOutConsumer().orElse(null), processConfiguration.getProcessInstanceConfiguration().flatMap(ProcessInstanceConfiguration::getStdOutConfiguration).orElse(null));
        this.processStdErr = new DefaultProcessOutput(processConfiguration.getStandardErrorRedirects(), processConfiguration.getStdErrConsumer().orElse(null), processConfiguration.getProcessInstanceConfiguration().flatMap(ProcessInstanceConfiguration::getStdErrConfiguration).orElse(null));
    }

    @Override
    public synchronized InputStream getStdOutInputStream() {
        if (this.stdOutPipedInputStream == null) {
            this.stdOutPipedInputStream = new PipedInputStream();
            this.stdOutPipedOutputStream = new PipedOutputStream();
            try {
                this.stdOutPipedOutputStream.connect(this.stdOutPipedInputStream);
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Fail to create piped input stream for process stdout", ioException);
            }
        }
        return this.stdOutPipedInputStream;
    }

    @Override
    public synchronized InputStream getStdErrInputStream() {
        if (this.stdErrPipedInputStream == null) {
            this.stdErrPipedInputStream = new PipedInputStream();
            this.stdErrPipedOutputStream = new PipedOutputStream();
            try {
                this.stdErrPipedOutputStream.connect(this.stdErrPipedInputStream);
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Fail to create piped input stream for process stderr", ioException);
            }
        }
        return this.stdErrPipedInputStream;
    }

    protected Executor getExecutor() {
        return this.processConfiguration.getExecutor().orElse(this.executorService);
    }

    protected Optional<Logger> getLogger() {
        return this.processConfiguration.getProcessLoggerConfiguration().flatMap(ProcessThreadLoggerConfiguration::getLogger);
    }

    public long getExecutionId() {
        return this.executionId;
    }

    protected Optional<InputStream> getStdIn() {
        return this.processConfiguration.getStdIn();
    }

    protected Map<String, String> getEnvVariables() {
        return this.processConfiguration.getEnvVariables();
    }

    protected Optional<String> getWorkDirectory() {
        return this.processConfiguration.getWorkDirectory();
    }

    protected ProcessDestroyerHandler getProcessDestroyerHandler() {
        return this.processConfiguration.getProcessDestroyerHandler().orElse(null);
    }

    protected Optional<ProcessDryRunConfiguration> getDryRunConfiguration() {
        return this.processConfiguration.getDryRunConfiguration();
    }

    protected List<String> getUnmaskedCommandAndArguments(Object ... commandAndArguments) {
        ArrayList<Object> caa = new ArrayList<Object>(this.processConfiguration.getCommandAndArguments());
        Collections.addAll(caa, commandAndArguments);
        return caa.stream().map(Object::toString).collect(Collectors.toList());
    }

    protected List<String> getMaskedCommandAndArguments(Object ... commandAndArguments) {
        ArrayList<Object> caa = new ArrayList<Object>(this.processConfiguration.getCommandAndArguments());
        Collections.addAll(caa, commandAndArguments);
        return caa.stream().map(Object::toString).collect(Collectors.toList());
    }

    protected void dumpCommandAndArguments(Object ... commandAndArguments) {
        if (!LOGGER.isTraceEnabled() && !this.getLogger().orElse(LOGGER).isDebugEnabled()) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            List<String> unmaskedCommandAndArguments = this.getUnmaskedCommandAndArguments(commandAndArguments);
            LOGGER.trace("Start [{}] the local OS process {}", (Object)this.getExecutionId(), unmaskedCommandAndArguments);
        }
        if (!this.getLogger().isPresent() && LOGGER.isTraceEnabled()) {
            return;
        }
        Logger logger = this.getLogger().orElse(LOGGER);
        if (logger.isDebugEnabled()) {
            List<String> maskedCommandAndArguments = this.getMaskedCommandAndArguments(commandAndArguments);
            logger.debug("Start [{}] the local OS process {}", (Object)this.getExecutionId(), maskedCommandAndArguments);
        }
    }

    protected DefaultProcessOutput getProcessStdOut() {
        return this.processStdOut;
    }

    protected DefaultProcessOutput getProcessStdErr() {
        return this.processStdErr;
    }

    protected void close() {
        this.processConfiguration.getStdIn().ifPresent(this::closeResource);
        this.closeResource(this.stdErrPipedOutputStream);
        this.closeResource(this.stdErrPipedInputStream);
        this.closeResource(this.stdOutPipedOutputStream);
        this.closeResource(this.stdOutPipedInputStream);
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected void closeResource(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {
            this.getLogger().orElse(LOGGER).warn("An error on closing piped stream", (Throwable)exception);
        }
    }
}

