/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.AerospikeLock;
import com.playtika.janusgraph.aerospike.AerospikeTransaction;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import com.playtika.janusgraph.aerospike.operations.ReadOperations;
import com.playtika.janusgraph.aerospike.operations.ScanOperations;
import com.playtika.janusgraph.aerospike.transaction.TransactionalOperations;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeKeyColumnValueStore
implements KeyColumnValueStore {
    private static Logger logger = LoggerFactory.getLogger(AerospikeKeyColumnValueStore.class);
    private final String storeName;
    private final ReadOperations readOperations;
    private final TransactionalOperations transactionalOperations;
    private final MutateOperations mutateOperations;
    private final ScanOperations scanOperations;

    AerospikeKeyColumnValueStore(String storeName, ReadOperations readOperations, TransactionalOperations transactionalOperations, ScanOperations scanOperations) {
        this.storeName = storeName;
        this.readOperations = readOperations;
        this.transactionalOperations = transactionalOperations;
        this.mutateOperations = transactionalOperations.getMutateOperations();
        this.scanOperations = scanOperations;
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) {
        return this.scanOperations.getKeys(this.storeName, query, txh);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        return this.readOperations.getSlice(this.storeName, keys, query, txh);
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        return this.readOperations.getSlice(this.storeName, query, txh);
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        AerospikeTransaction transaction = (AerospikeTransaction)txh;
        Map<Value, Value> mutationMap = AerospikeKeyColumnValueStore.mutationToMap(new KCVMutation(additions, deletions));
        Value keyValue = AerospikeOperations.getValue(key);
        if (transaction.getLocks().isEmpty()) {
            this.mutateOperations.mutate(this.storeName, keyValue, mutationMap);
            return;
        }
        Map<String, Map<Value, Map<Value, Value>>> locksByStore = transaction.getLocksByStoreKeyColumn();
        if (!Collections.singleton(this.storeName).containsAll(locksByStore.keySet())) {
            throw new IllegalArgumentException();
        }
        Map locks = locksByStore.getOrDefault(this.storeName, Collections.emptyMap());
        if (!Collections.singleton(keyValue).containsAll(locks.keySet())) {
            throw new IllegalArgumentException();
        }
        Map<String, Map<Value, Map<Value, Value>>> mutationsByStore = Collections.singletonMap(this.storeName, Collections.singletonMap(keyValue, mutationMap));
        this.transactionalOperations.mutateTransactionally(locksByStore, mutationsByStore);
    }

    static Map<Value, Value> mutationToMap(KCVMutation mutation) {
        HashMap<Value, Value> map = new HashMap<Value, Value>(mutation.getAdditions().size() + mutation.getDeletions().size());
        for (StaticBuffer deletion : mutation.getDeletions()) {
            map.put(AerospikeOperations.getValue(deletion), Value.NULL);
        }
        for (Entry addition : mutation.getAdditions()) {
            map.put(AerospikeOperations.getValue(addition.getColumn()), AerospikeOperations.getValue(addition.getValue()));
        }
        return map;
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) {
        ((AerospikeTransaction)txh).addLock(new AerospikeLock(this.storeName, key, column, expectedValue));
        if (logger.isTraceEnabled()) {
            logger.trace("registered lock: {}:{}:{}:{}, tx:{}", new Object[]{this.storeName, key, column, expectedValue, txh});
        }
    }

    public synchronized void close() {
    }

    public String getName() {
        return this.storeName;
    }
}

