/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.ClientPolicy;
import com.google.common.util.concurrent.MoreExecutors;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class AerospikeOperations {
    private static final int DEFAULT_PORT = 3000;
    static final String ENTRIES_BIN_NAME = "entries";
    private final String namespace;
    private final String graphPrefix;
    private final IAerospikeClient client;
    private final ExecutorService aerospikeExecutor;
    private final AerospikePolicyProvider aerospikePolicyProvider;

    public AerospikeOperations(String graphPrefix, String namespace, IAerospikeClient client, AerospikePolicyProvider aerospikePolicyProvider, ExecutorService aerospikeExecutor) {
        this.graphPrefix = graphPrefix + ".";
        this.namespace = namespace;
        this.client = client;
        this.aerospikePolicyProvider = aerospikePolicyProvider;
        this.aerospikeExecutor = aerospikeExecutor;
    }

    public IAerospikeClient getClient() {
        return this.client;
    }

    public String getNamespace() {
        return this.namespace;
    }

    Key getKey(String storeName, StaticBuffer staticBuffer) {
        return this.getKey(storeName, AerospikeOperations.getValue(staticBuffer));
    }

    public static Value getValue(StaticBuffer staticBuffer) {
        return (Value)staticBuffer.as((array, offset, limit) -> Value.get((byte[])array, (int)offset, (int)(limit - offset)));
    }

    Key getKey(String storeName, Value value) {
        return new Key(this.namespace, this.getSetName(storeName), value);
    }

    String getSetName(String storeName) {
        return this.graphPrefix + storeName;
    }

    Executor getAerospikeExecutor() {
        return this.aerospikeExecutor;
    }

    public AerospikePolicyProvider getAerospikePolicyProvider() {
        return this.aerospikePolicyProvider;
    }

    public String getGraphPrefix() {
        return this.graphPrefix;
    }

    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.aerospikeExecutor, (long)4L, (TimeUnit)TimeUnit.SECONDS);
        this.client.close();
    }

    public static IAerospikeClient buildAerospikeClient(Configuration configuration) {
        int port = configuration.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]) ? (Integer)configuration.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]) : 3000;
        Host[] hosts = (Host[])Stream.of((Object[])configuration.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0])).map(hostname -> new Host(hostname, port)).toArray(Host[]::new);
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.user = configuration.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) ? (String)configuration.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) : null;
        clientPolicy.password = configuration.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]) ? (String)configuration.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]) : null;
        return new AerospikeClient(clientPolicy, hosts);
    }
}

