/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.LockOperations;
import com.playtika.janusgraph.aerospike.util.AsyncUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.locking.TemporaryLockingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLockOperations
implements LockOperations {
    private static Logger logger = LoggerFactory.getLogger(BasicLockOperations.class);
    private static final String TRANSACTION_BIN_NAME = "transaction";
    private static final WritePolicy checkValuesPolicy = new WritePolicy();
    private final AerospikeOperations aerospikeOperations;
    private final IAerospikeClient client;
    private final WritePolicy putLockPolicy;
    private final WritePolicy deleteLockPolicy;

    public BasicLockOperations(AerospikeOperations aerospikeOperations) {
        this.aerospikeOperations = aerospikeOperations;
        this.client = aerospikeOperations.getClient();
        AerospikePolicyProvider aerospikePolicyProvider = aerospikeOperations.getAerospikePolicyProvider();
        this.putLockPolicy = new WritePolicy(aerospikePolicyProvider.writePolicy());
        this.putLockPolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        this.deleteLockPolicy = aerospikePolicyProvider.deletePolicy();
    }

    @Override
    public Set<Key> acquireLocks(Value transactionId, Map<String, Map<Value, Map<Value, Value>>> locksByStore, boolean checkTransactionId, Consumer<Map<Key, LockOperations.LockType>> onErrorCleanup) throws BackendException {
        Map<Key, LockOperations.LockType> keysLocked = this.putLocks(transactionId, locksByStore, checkTransactionId, onErrorCleanup);
        try {
            this.checkExpectedValues(locksByStore, keysLocked);
        }
        catch (Throwable t) {
            onErrorCleanup.accept(keysLocked);
            throw t;
        }
        return keysLocked.keySet();
    }

    private Map<Key, LockOperations.LockType> putLocks(Value transactionId, Map<String, Map<Value, Map<Value, Value>>> locksByStore, boolean checkTransactionId, Consumer<Map<Key, LockOperations.LockType>> onErrorCleanup) throws BackendException {
        ConcurrentHashMap<Key, LockOperations.LockType> keysLocked = new ConcurrentHashMap<Key, LockOperations.LockType>();
        ArrayList futures = new ArrayList();
        AtomicReference alreadyLockedError = new AtomicReference();
        try {
            for (Map.Entry<String, Map<Value, Map<Value, Value>>> locksForStore : locksByStore.entrySet()) {
                String storeName = locksForStore.getKey();
                for (Value key : locksForStore.getValue().keySet()) {
                    futures.add(CompletableFuture.runAsync(() -> {
                        if (alreadyLockedError.get() != null) {
                            return;
                        }
                        Key lockKey = this.getLockKey(storeName, key);
                        try {
                            LockOperations.LockType lockType = this.putLock(transactionId, lockKey, checkTransactionId);
                            keysLocked.put(lockKey, lockType);
                            if (logger.isTraceEnabled()) {
                                logger.trace("acquired lock key=[{}], txId=[{}]", (Object)lockKey, (Object)transactionId);
                            }
                        }
                        catch (AerospikeException e) {
                            if (e.getResultCode() == 5) {
                                alreadyLockedError.set(e);
                                logger.info("already locked key=[{}], txId=[{}]", (Object)lockKey, (Object)transactionId);
                            }
                            throw e;
                        }
                    }, this.aerospikeOperations.getAerospikeExecutor()));
                }
            }
            AsyncUtil.completeAll(futures);
            if (alreadyLockedError.get() != null) {
                throw new TemporaryLockingException("Some locks not released yet", (Throwable)alreadyLockedError.get());
            }
        }
        catch (Throwable t) {
            onErrorCleanup.accept(keysLocked);
            throw t;
        }
        return keysLocked;
    }

    private LockOperations.LockType putLock(Value transactionId, Key lockKey, boolean checkTransactionId) {
        if (checkTransactionId) {
            try {
                this.client.add(this.putLockPolicy, lockKey, new Bin[]{new Bin(TRANSACTION_BIN_NAME, transactionId)});
                return LockOperations.LockType.LOCKED;
            }
            catch (AerospikeException e) {
                Record record;
                if (e.getResultCode() == 5 && this.checkTransaction(record = this.client.get(null, lockKey), transactionId)) {
                    return LockOperations.LockType.SAME_TRANSACTION;
                }
                throw e;
            }
        }
        this.client.add(this.putLockPolicy, lockKey, new Bin[]{new Bin(TRANSACTION_BIN_NAME, transactionId)});
        return LockOperations.LockType.LOCKED;
    }

    private boolean checkTransaction(Record record, Value transactionId) {
        Value transactionIdLocked = Value.get((Object)record.getValue(TRANSACTION_BIN_NAME));
        return transactionId.equals(transactionIdLocked);
    }

    @Override
    public List<Key> filterKeysLockedByTransaction(Map<String, Map<Value, Map<Value, Value>>> locksByStore, Value transactionId) {
        List<Key> keys = this.getLockKeys(locksByStore);
        ArrayList<Key> keysFiltered = new ArrayList<Key>(keys.size());
        Key[] keysArray = keys.toArray(new Key[0]);
        Record[] records = this.client.get(null, keysArray);
        int m = keysArray.length;
        for (int i = 0; i < m; ++i) {
            Record record = records[i];
            if (record == null || !this.checkTransaction(record, transactionId)) continue;
            keysFiltered.add(keysArray[i]);
        }
        return keysFiltered;
    }

    private List<Key> getLockKeys(Map<String, Map<Value, Map<Value, Value>>> locksByStore) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Map.Entry<String, Map<Value, Map<Value, Value>>> locksForStore : locksByStore.entrySet()) {
            String storeName = locksForStore.getKey();
            for (Value key : locksForStore.getValue().keySet()) {
                keys.add(this.getLockKey(storeName, key));
            }
        }
        return keys;
    }

    @Override
    public void releaseLocks(Collection<Key> keys) {
        ArrayList futures = new ArrayList(keys.size());
        for (Key lockKey : keys) {
            futures.add(CompletableFuture.runAsync(() -> this.client.delete(this.deleteLockPolicy, lockKey), this.aerospikeOperations.getAerospikeExecutor()));
        }
        AsyncUtil.completeAll(futures);
    }

    protected void checkExpectedValues(Map<String, Map<Value, Map<Value, Value>>> locksByStore, Map<Key, LockOperations.LockType> keysLocked) throws PermanentBackendException {
        ArrayList futures = new ArrayList();
        AtomicBoolean checkFailed = new AtomicBoolean(false);
        for (Map.Entry<String, Map<Value, Map<Value, Value>>> locksForStore : locksByStore.entrySet()) {
            String storeName = locksForStore.getKey();
            for (Map.Entry<Value, Map<Value, Value>> locksForKey : locksForStore.getValue().entrySet()) {
                if (keysLocked.get(this.getLockKey(storeName, locksForKey.getKey())) == LockOperations.LockType.SAME_TRANSACTION) continue;
                futures.add(CompletableFuture.runAsync(() -> {
                    if (checkFailed.get()) {
                        return;
                    }
                    if (!this.checkColumnValues(this.aerospikeOperations.getKey(storeName, (Value)locksForKey.getKey()), (Map)locksForKey.getValue())) {
                        checkFailed.set(true);
                    }
                }, this.aerospikeOperations.getAerospikeExecutor()));
            }
        }
        AsyncUtil.completeAll(futures);
        if (checkFailed.get()) {
            throw new PermanentLockingException("Some values don't match expected values");
        }
    }

    private boolean checkColumnValues(Key key, Map<Value, Value> locksForKey) {
        block10: {
            if (locksForKey.isEmpty()) {
                return true;
            }
            try {
                int columnsNo = locksForKey.size();
                Value[] columns = new Value[columnsNo];
                Operation[] operations = new Operation[columnsNo];
                int i = 0;
                Iterator<Value> iterator = locksForKey.keySet().iterator();
                while (iterator.hasNext()) {
                    Value column;
                    columns[i] = column = iterator.next();
                    operations[i] = MapOperation.getByKey((String)"entries", (Value)column, (int)7);
                    ++i;
                }
                Record record = this.client.operate(checkValuesPolicy, key, operations);
                if (record != null) {
                    if (columnsNo > 1) {
                        List resultList = record.getList("entries");
                        if (resultList != null) {
                            int n = resultList.size();
                            for (int j = 0; j < n; ++j) {
                                Value column = columns[j];
                                if (this.checkValue(key, column, locksForKey.get(column), (byte[])resultList.get(j))) continue;
                                return false;
                            }
                        }
                    } else if (columnsNo == 1) {
                        byte[] actualValueData = (byte[])record.getValue("entries");
                        Value column = columns[0];
                        return this.checkValue(key, column, locksForKey.get(column), actualValueData);
                    }
                    break block10;
                }
                return locksForKey.values().stream().allMatch(value -> value.equals(Value.NULL));
            }
            catch (Throwable t) {
                logger.error("Error while checkColumnValues for key={}, values={}", new Object[]{key, locksForKey, t});
                throw t;
            }
        }
        return true;
    }

    private boolean checkValue(Key key, Value column, Value expectedValue, byte[] actualValue) {
        if (expectedValue.equals(Value.get((byte[])actualValue)) || expectedValue instanceof Value.ByteSegmentValue && expectedValue.equals(Value.get((byte[])actualValue, (int)0, (int)(actualValue != null ? actualValue.length : 0)))) {
            return true;
        }
        logger.info("Unexpected value for key {}, column {}, expected {}, actual {}", new Object[]{key, column, expectedValue, actualValue});
        return false;
    }

    private Key getLockKey(String storeName, Value value) {
        return this.aerospikeOperations.getKey(storeName + ".lock", value);
    }

    static {
        BasicLockOperations.checkValuesPolicy.respondAllOps = true;
    }
}

