/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.ScanCallback;
import com.aerospike.client.policy.ScanPolicy;
import com.google.common.util.concurrent.MoreExecutors;
import com.playtika.janusgraph.aerospike.operations.AerospikeKeyIterator;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.ScanOperations;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;

public class BasicScanOperations
implements ScanOperations {
    private final AerospikeOperations aerospikeOperations;
    private final ScanPolicy scanPolicy;
    private final ExecutorService scanExecutor;

    public BasicScanOperations(AerospikeOperations aerospikeOperations, ExecutorService scanExecutor) {
        this.aerospikeOperations = aerospikeOperations;
        this.scanPolicy = aerospikeOperations.getAerospikePolicyProvider().scanPolicy();
        this.scanExecutor = scanExecutor;
    }

    @Override
    public KeyIterator getKeys(String storeName, SliceQuery query, StoreTransaction txh) {
        AerospikeKeyIterator keyIterator = new AerospikeKeyIterator(query);
        this.scanExecutor.execute(() -> {
            try {
                this.aerospikeOperations.getClient().scanAll(this.scanPolicy, this.aerospikeOperations.getNamespace(), this.aerospikeOperations.getSetName(storeName), (ScanCallback)keyIterator, new String[0]);
            }
            finally {
                keyIterator.terminate();
            }
        });
        return keyIterator;
    }

    @Override
    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.scanExecutor, (long)4L, (TimeUnit)TimeUnit.SECONDS);
    }
}

