/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.util.AsyncUtil;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;

public class ReadOperations {
    private final AerospikeOperations aerospikeOperations;
    private final WritePolicy getPolicy;

    public ReadOperations(AerospikeOperations aerospikeOperations) {
        this.aerospikeOperations = aerospikeOperations;
        this.getPolicy = aerospikeOperations.getAerospikePolicyProvider().writePolicy();
    }

    public Map<StaticBuffer, EntryList> getSlice(String storeName, List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        return AsyncUtil.mapAll(keys, key -> {
            try {
                return this.getSlice(storeName, new KeySliceQuery(key, query), txh);
            }
            catch (BackendException e) {
                throw new RuntimeException(e);
            }
        }, this.aerospikeOperations.getAerospikeExecutor());
    }

    public EntryList getSlice(String storeName, KeySliceQuery query, StoreTransaction txh) throws BackendException {
        try {
            Record record = this.aerospikeOperations.getClient().operate(this.getPolicy, this.aerospikeOperations.getKey(storeName, query.getKey()), new Operation[]{MapOperation.getByKeyRange((String)"entries", (Value)AerospikeOperations.getValue(query.getSliceStart()), (Value)AerospikeOperations.getValue(query.getSliceEnd()), (int)8)});
            return this.recordToEntries(record, query.getLimit());
        }
        catch (AerospikeException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private EntryList recordToEntries(Record record, int entriesNo) {
        List resultList;
        if (record != null && (resultList = record.getList("entries")) != null && !resultList.isEmpty()) {
            EntryArrayList result = new EntryArrayList();
            resultList.stream().limit(entriesNo).forEach(o -> {
                Map.Entry entry = (Map.Entry)o;
                result.add((Object)StaticArrayEntry.of((StaticBuffer)StaticArrayBuffer.of((byte[])((byte[])entry.getKey())), (StaticBuffer)StaticArrayBuffer.of((byte[])((byte[])entry.getValue()))));
            });
            return result;
        }
        return EntryList.EMPTY_LIST;
    }
}

