/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.transaction;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import com.playtika.janusgraph.aerospike.transaction.WalOperations;
import com.playtika.janusgraph.aerospike.transaction.WriteAheadLogManager;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteAheadLogManagerBasic
implements WriteAheadLogManager {
    private static Logger logger = LoggerFactory.getLogger(WriteAheadLogManagerBasic.class);
    private static final String UUID_BIN = "uuid";
    private static final String TIMESTAMP_BIN = "timestamp";
    private static final String LOCKS_BIN = "locks";
    private static final String MUTATIONS_BIN = "mutations";
    private final IAerospikeClient client;
    private final String walNamespace;
    private final String walSetName;
    private final String secondaryIndexName;
    private final Clock clock;
    private final long staleTransactionLifetimeThresholdInMs;
    private WritePolicy writePolicy;
    private WritePolicy deletePolicy;

    public WriteAheadLogManagerBasic(WalOperations walOperations, Clock clock) {
        this.client = walOperations.getAerospikeOperations().getClient();
        this.walNamespace = walOperations.getWalNamespace();
        this.secondaryIndexName = this.walSetName = walOperations.getWalSetName();
        this.clock = clock;
        this.staleTransactionLifetimeThresholdInMs = walOperations.getStaleTransactionLifetimeThresholdInMs();
        AerospikePolicyProvider aerospikePolicyProvider = walOperations.getAerospikeOperations().getAerospikePolicyProvider();
        this.writePolicy = new WritePolicy(aerospikePolicyProvider.writePolicy());
        this.writePolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        this.deletePolicy = aerospikePolicyProvider.deletePolicy();
        try {
            this.client.createIndex(null, this.walNamespace, this.walSetName, this.secondaryIndexName, TIMESTAMP_BIN, IndexType.NUMERIC).waitTillComplete(200, 0);
        }
        catch (AerospikeException ae) {
            if (ae.getResultCode() == 200) {
                logger.info("Will not create WAL secondary index as it already exists");
            }
            throw ae;
        }
    }

    @Override
    public Value writeTransaction(Map<String, Map<Value, Map<Value, Value>>> locks, Map<String, Map<Value, Map<Value, Value>>> mutations) {
        Value transactionId = Value.get((byte[])WriteAheadLogManagerBasic.getBytesFromUUID(UUID.randomUUID()));
        try {
            this.client.put(this.writePolicy, new Key(this.walNamespace, this.walSetName, transactionId), new Bin[]{new Bin(UUID_BIN, transactionId), new Bin(TIMESTAMP_BIN, Value.get((long)this.clock.millis())), new Bin(LOCKS_BIN, this.stringMapToValue(locks)), new Bin(MUTATIONS_BIN, this.stringMapToValue(mutations))});
        }
        catch (AerospikeException ae) {
            if (ae.getResultCode() == 13) {
                logger.error("locks data size: {}", (Object)WriteAheadLogManagerBasic.toBytes(this.stringMapToValue(locks)).length);
                logger.error("mutations data size: {}", (Object)WriteAheadLogManagerBasic.toBytes(this.stringMapToValue(mutations)).length);
            }
            throw ae;
        }
        return transactionId;
    }

    @Override
    public void deleteTransaction(Value transactionId) {
        this.client.delete(this.deletePolicy, new Key(this.walNamespace, this.walSetName, transactionId));
    }

    private Value stringMapToValue(Map<String, Map<Value, Map<Value, Value>>> map) {
        HashMap<Value, Map<Value, Map<Value, Value>>> locksValue = new HashMap<Value, Map<Value, Map<Value, Value>>>(map.size());
        for (Map.Entry<String, Map<Value, Map<Value, Value>>> locksEntry : map.entrySet()) {
            locksValue.put(Value.get((String)locksEntry.getKey()), locksEntry.getValue());
        }
        return Value.get(locksValue);
    }

    public static byte[] getBytesFromUUID(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    @Override
    public List<WriteAheadLogManager.WalTransaction> getStaleTransactions() {
        Statement statement = new Statement();
        statement.setNamespace(this.walNamespace);
        statement.setSetName(this.walSetName);
        statement.setFilter(Filter.range((String)TIMESTAMP_BIN, (long)0L, (long)Math.max(this.clock.millis() - this.staleTransactionLifetimeThresholdInMs, 0L)));
        RecordSet recordSet = this.client.query(null, statement);
        ArrayList<WriteAheadLogManager.WalTransaction> staleTransactions = new ArrayList<WriteAheadLogManager.WalTransaction>();
        recordSet.iterator().forEachRemaining(keyRecord -> {
            Record record = keyRecord.record;
            staleTransactions.add(new WriteAheadLogManager.WalTransaction(Value.get((Object)record.getValue(UUID_BIN)), record.getLong(TIMESTAMP_BIN), WriteAheadLogManagerBasic.wrapMap(record.getMap(LOCKS_BIN)), WriteAheadLogManagerBasic.wrapMap(record.getMap(MUTATIONS_BIN))));
        });
        Collections.sort(staleTransactions);
        return staleTransactions;
    }

    private static Map<String, Map<Value, Map<Value, Value>>> wrapMap(Map<String, Map<byte[], Map<byte[], byte[]>>> map) {
        HashMap<String, Map<Value, Map<Value, Value>>> resultMap = new HashMap<String, Map<Value, Map<Value, Value>>>(map.size());
        for (Map.Entry<String, Map<byte[], Map<byte[], byte[]>>> mapEntry : map.entrySet()) {
            resultMap.put(mapEntry.getKey(), WriteAheadLogManagerBasic.wrapBytesBytesMap(mapEntry.getValue()));
        }
        return resultMap;
    }

    private static Map<Value, Map<Value, Value>> wrapBytesBytesMap(Map<byte[], Map<byte[], byte[]>> map) {
        HashMap<Value, Map<Value, Value>> resultMap = new HashMap<Value, Map<Value, Value>>(map.size());
        for (Map.Entry<byte[], Map<byte[], byte[]>> mapEntry : map.entrySet()) {
            resultMap.put(Value.get((byte[])mapEntry.getKey()), WriteAheadLogManagerBasic.wrapBytesMap(mapEntry.getValue()));
        }
        return resultMap;
    }

    private static Map<Value, Value> wrapBytesMap(Map<byte[], byte[]> map) {
        HashMap<Value, Value> resultMap = new HashMap<Value, Value>(map.size());
        for (Map.Entry<byte[], byte[]> mapEntry : map.entrySet()) {
            resultMap.put(Value.get((byte[])mapEntry.getKey()), Value.get((byte[])mapEntry.getValue()));
        }
        return resultMap;
    }

    static byte[] toBytes(Value value) {
        byte[] bytes = new byte[value.estimateSize()];
        value.write(bytes, 0);
        return bytes;
    }
}

