/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.janusgraph.diskstorage.PermanentBackendException;

public class AsyncUtil {
    public static final int WAIT_TIMEOUT_IN_SECONDS = 4;

    public static void completeAll(List<CompletableFuture<?>> futures) {
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> mapAll(Collection<K> keys, Function<K, V> valueFunction, Executor executor) throws PermanentBackendException {
        HashMap<K, CompletableFuture<Object>> futures = new HashMap<K, CompletableFuture<Object>>(keys.size());
        for (Object key : keys) {
            futures.put(key, CompletableFuture.supplyAsync(() -> valueFunction.apply(key), executor));
        }
        return AsyncUtil.getAll(futures);
    }

    public static <K, V> Map<K, V> getAll(Map<K, CompletableFuture<V>> futureMap) throws PermanentBackendException {
        HashMap<K, V> resultMap = new HashMap<K, V>(futureMap.size());
        try {
            for (Map.Entry<K, CompletableFuture<V>> entry : futureMap.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue().get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        return resultMap;
    }
}

