/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.ConfigOptions;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class AerospikePolicyProvider {
    private Configuration configuration;

    public AerospikePolicyProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    public ClientPolicy clientPolicy() {
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.user = this.configuration.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) ? (String)this.configuration.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) : null;
        clientPolicy.password = this.configuration.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]) ? (String)this.configuration.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]) : null;
        clientPolicy.maxConnsPerNode = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_CONNECTIONS_PER_NODE, new String[0]);
        clientPolicy.readPolicyDefault = this.readPolicy();
        clientPolicy.scanPolicyDefault = this.scanPolicy();
        clientPolicy.queryPolicyDefault = this.queryPolicy();
        clientPolicy.writePolicyDefault = this.writePolicy();
        clientPolicy.batchPolicyDefault = this.batchPolicy();
        return clientPolicy;
    }

    public BatchPolicy batchPolicy() {
        BatchPolicy batchPolicy = new BatchPolicy();
        batchPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_WRITE_TIMEOUT, new String[0]);
        return batchPolicy;
    }

    public QueryPolicy queryPolicy() {
        QueryPolicy queryPolicy = new QueryPolicy();
        queryPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        return queryPolicy;
    }

    public WritePolicy writePolicy() {
        WritePolicy writePolicy = new WritePolicy();
        writePolicy.sendKey = true;
        writePolicy.expiration = -1;
        writePolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_WRITE_TIMEOUT, new String[0]);
        return writePolicy;
    }

    public WritePolicy deletePolicy() {
        WritePolicy deletePolicy = new WritePolicy();
        deletePolicy.expiration = -1;
        deletePolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_WRITE_TIMEOUT, new String[0]);
        deletePolicy.durableDelete = (Boolean)this.configuration.get(ConfigOptions.TEST_ENVIRONMENT, new String[0]) == false;
        return deletePolicy;
    }

    public Policy readPolicy() {
        Policy readPolicy = new Policy();
        readPolicy.sendKey = true;
        readPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        return readPolicy;
    }

    public ScanPolicy scanPolicy() {
        ScanPolicy scanPolicy = new ScanPolicy();
        scanPolicy.sendKey = true;
        scanPolicy.includeBinData = true;
        scanPolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        scanPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        return scanPolicy;
    }
}

