/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.playtika.janusgraph.aerospike.AerospikeKeyColumnValueStore;
import com.playtika.janusgraph.aerospike.AerospikeTransaction;
import com.playtika.janusgraph.aerospike.ConfigOptions;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.BasicOperations;
import com.playtika.janusgraph.aerospike.operations.Operations;
import com.playtika.janusgraph.aerospike.util.AerospikeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.common.AbstractStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class AerospikeStoreManager
extends AbstractStoreManager
implements KeyColumnValueStoreManager {
    private static Logger logger = LoggerFactory.getLogger(AerospikeStoreManager.class);
    public static final int AEROSPIKE_BUFFER_SIZE = 0x3FFFFFFF;
    private final StoreFeatures features;
    private final Operations operations;

    public AerospikeStoreManager(Configuration configuration) {
        super(configuration);
        Preconditions.checkArgument(((Integer)configuration.get(GraphDatabaseConfiguration.BUFFER_SIZE, new String[0]) == 0x3FFFFFFF ? 1 : 0) != 0, (Object)"Set unlimited buffer size as we use deferred locking approach");
        this.features = this.features(configuration);
        this.operations = this.initOperations(configuration);
        if (((Boolean)configuration.get(ConfigOptions.START_WAL_COMPLETER, new String[0])).booleanValue()) {
            this.operations.getWriteAheadLogCompleter().start();
        }
    }

    protected BasicOperations initOperations(Configuration configuration) {
        return new BasicOperations(configuration);
    }

    private StandardStoreFeatures features(Configuration configuration) {
        return new StandardStoreFeatures.Builder().keyConsistent(configuration).persists(true).locking(true).optimisticLocking(true).transactional(false).distributed(true).multiQuery(true).batchMutation(true).unorderedScan(true).orderedScan(false).keyOrdered(false).localKeyPartition(false).timestamps(false).supportsInterruption(false).build();
    }

    public StoreTransaction beginTransaction(BaseTransactionConfig config) {
        return new AerospikeTransaction(config);
    }

    public KeyColumnValueStore openDatabase(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Database name may not be null or empty");
        return new AerospikeKeyColumnValueStore(name, this.operations.getReadOperations(), this.operations.getTransactionalOperations(), this.operations.getScanOperations());
    }

    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) {
        return this.openDatabase(name);
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        logger.trace("mutateMany(tx:{}, {})", (Object)txh, mutations);
        Map<String, Map<Value, Map<Value, Value>>> locksByStore = ((AerospikeTransaction)txh).getLocksByStoreKeyColumn();
        Map<String, Map<Value, Map<Value, Value>>> mutationsByStore = AerospikeStoreManager.groupMutationsByStoreKeyColumn(mutations);
        this.operations.getTransactionalOperations().mutateTransactionally(locksByStore, mutationsByStore);
    }

    private static Map<String, Map<Value, Map<Value, Value>>> groupMutationsByStoreKeyColumn(Map<String, Map<StaticBuffer, KCVMutation>> mutationsByStore) {
        HashMap<String, Map<Value, Map<Value, Value>>> mapByStore = new HashMap<String, Map<Value, Map<Value, Value>>>(mutationsByStore.size());
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> storeMutations : mutationsByStore.entrySet()) {
            HashMap<Value, Map<Value, Value>> map = new HashMap<Value, Map<Value, Value>>(storeMutations.getValue().size());
            for (Map.Entry<StaticBuffer, KCVMutation> mutationEntry : storeMutations.getValue().entrySet()) {
                map.put(AerospikeOperations.getValue(mutationEntry.getKey()), AerospikeKeyColumnValueStore.mutationToMap(mutationEntry.getValue()));
            }
            mapByStore.put(storeMutations.getKey(), map);
        }
        return mapByStore;
    }

    public void close() {
        this.operations.close();
    }

    public void clearStorage() throws BackendException {
        try {
            AerospikeOperations aerospikeOperations = this.operations.getAerospikeOperations();
            AerospikeUtils.truncateNamespace(aerospikeOperations.getClient(), aerospikeOperations.getNamespace());
        }
        catch (AerospikeException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists() throws BackendException {
        try {
            AerospikeOperations aerospikeOperations = this.operations.getAerospikeOperations();
            return !AerospikeUtils.isEmptyNamespace(aerospikeOperations.getClient(), aerospikeOperations.getNamespace());
        }
        catch (AerospikeException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":HARDCODED";
    }

    public StoreFeatures getFeatures() {
        return this.features;
    }

    public List<KeyRange> getLocalKeyPartition() {
        throw new UnsupportedOperationException();
    }

    public Operations getOperations() {
        return this.operations;
    }
}

